/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.geotools.api.geometry.Bounds;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.JMapPane;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.AbstractZoomTool;

public class ScrollWheelTool
extends AbstractZoomTool {
    public ScrollWheelTool(JMapPane mapPane) {
        this.setMapPane(mapPane);
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public void onMouseWheelMoved(MapMouseEvent ev) {
        Rectangle paneArea = ((JComponent)((Object)this.getMapPane())).getVisibleRect();
        Position2D mapPos = ev.getWorldPos();
        double scale = this.getMapPane().getWorldToScreenTransform().getScaleX();
        int clicks = ev.getWheelAmount();
        double actualZoom = 1.0;
        actualZoom = clicks > 0 ? -1.0 / ((double)clicks * this.getZoom()) : (double)clicks * this.getZoom();
        double newScale = scale * actualZoom;
        Position2D corner = new Position2D(mapPos.getX() - 0.5 * paneArea.getWidth() / newScale, mapPos.getY() + 0.5 * paneArea.getHeight() / newScale);
        ReferencedEnvelope newMapArea = new ReferencedEnvelope();
        newMapArea.setFrameFromCenter((Point2D)mapPos, (Point2D)corner);
        this.getMapPane().setDisplayArea((Bounds)newMapArea);
    }
}

