/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wizard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.geotools.api.data.Parameter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.swing.wizard.JWizard;
import org.geotools.swing.wizard.ParamField;
import org.geotools.util.Converters;

public class JField
extends ParamField {
    private JTextComponent text;
    private boolean single = true;

    public JField(Parameter<?> parameter) {
        super(parameter);
    }

    public void setSingleLine(boolean single) {
        this.single = single;
    }

    @Override
    public JComponent doLayout() {
        if (this.parameter.metadata != null && this.parameter.metadata.get("isPassword") == Boolean.TRUE) {
            this.text = new JPasswordField(32);
        } else if (this.single) {
            this.text = new JTextField(32);
        } else {
            this.text = new JTextArea(40, 2);
            ((JTextArea)this.text).setWrapStyleWord(true);
        }
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                JField.this.validate();
            }
        });
        if (this.text instanceof JTextArea) {
            JScrollPane scroll = new JScrollPane(this.text, 22, 31);
            scroll.setPreferredSize(new Dimension(400, 80));
            return scroll;
        }
        return this.text;
    }

    @Override
    public Object getValue() {
        String txt = this.text.getText();
        if (txt.length() == 0) {
            return null;
        }
        Object value = Converters.convert((Object)txt, (Class)this.parameter.type);
        return value;
    }

    int getD() {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.parameter.metadata.get("crs");
        if (crs == null) {
            return 2;
        }
        return crs.getCoordinateSystem().getDimension();
    }

    @Override
    public void setValue(Object value) {
        String txt = (String)Converters.convert((Object)value, String.class);
        this.text.setText(txt);
    }

    @Override
    public void addListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public void removeListener(JWizard.Controller controller) {
        this.text.addKeyListener(controller);
    }

    @Override
    public boolean validate() {
        String txt = this.text.getText();
        if (txt.length() == 0) {
            return true;
        }
        Object value = Converters.convert((Object)txt, (Class)this.parameter.type);
        if (value == null) {
            this.text.setToolTipText("Could not create " + this.parameter.type);
            this.text.setForeground(Color.RED);
            return false;
        }
        this.text.setToolTipText(null);
        this.text.setForeground(Color.BLACK);
        return true;
    }
}

