/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.tile.TileService;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class TileLayer
extends DirectLayer {
    private static final Logger LOGGER = Logging.getLogger(TileLayer.class);
    private static final GridCoverageFactory gridFactory = new GridCoverageFactory();
    private TileService service;
    private double resolution = 90.0;
    private GridCoverage2D coverage;

    public TileLayer(TileService service) {
        this.service = service;
    }

    public GridCoverage2D getCoverage() {
        return this.coverage;
    }

    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(-180.0, 180.0, -85.0, 85.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public void draw(Graphics2D graphics, MapContent map, MapViewport theViewport) {
        LOGGER.fine("Started drawing");
        MapViewport viewport = new MapViewport(theViewport);
        ReferencedEnvelope viewportExtent = viewport.getBounds();
        int scale = this.calculateScale(viewportExtent, viewport.getScreenArea());
        Set<Tile> tiles = this.service.findTilesInExtent(viewportExtent, scale, false, 128);
        BufferedImage mosaickedImage = this.createImage(viewport.getScreenArea());
        Graphics2D g2d = mosaickedImage.createGraphics();
        this.renderTiles(tiles, g2d, viewportExtent, viewport.getWorldToScreen());
        this.coverage = gridFactory.create((CharSequence)"GridCoverage", (RenderedImage)mosaickedImage, (Envelope)viewportExtent);
        graphics.drawImage((Image)mosaickedImage, 0, 0, null);
        LOGGER.fine("Drawing done");
    }

    protected void renderTiles(Collection<Tile> tiles, Graphics2D g2d, ReferencedEnvelope viewportExtent, AffineTransform worldToImageTransform) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double[] points = new double[4];
        for (Tile tile : tiles) {
            ReferencedEnvelope tileEnvViewport;
            ReferencedEnvelope nativeTileEnvelope = tile.getExtent();
            try {
                tileEnvViewport = nativeTileEnvelope.transform(viewportExtent.getCoordinateReferenceSystem(), true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
            points[0] = tileEnvViewport.getMinX();
            points[3] = tileEnvViewport.getMinY();
            points[2] = tileEnvViewport.getMaxX();
            points[1] = tileEnvViewport.getMaxY();
            worldToImageTransform.transform(points, 0, points, 0, 2);
            this.renderTile(tile, g2d, points);
        }
    }

    protected void renderTile(Tile tile, Graphics2D g2d, double[] points) {
        BufferedImage img = this.getTileImage(tile);
        g2d.drawImage(img, (int)points[0], (int)points[1], (int)Math.ceil(points[2] - points[0]), (int)Math.ceil(points[3] - points[1]), null);
    }

    protected BufferedImage getTileImage(Tile tile) {
        return tile.getBufferedImage();
    }

    private int calculateScale(ReferencedEnvelope extent, Rectangle screenArea) {
        int scale = 0;
        try {
            scale = (int)Math.round(RendererUtilities.calculateScale((ReferencedEnvelope)extent, (int)screenArea.width, (int)screenArea.height, (double)this.resolution));
        }
        catch (FactoryException | TransformException ex) {
            throw new RuntimeException("Failed to calculate scale", ex);
        }
        return scale;
    }

    private BufferedImage createImage(Rectangle rectangle) {
        return new BufferedImage(rectangle.width, rectangle.height, 2);
    }
}

