/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class CRSEvaluator
implements ExpressionVisitor {
    private SimpleFeatureType schema;

    public CRSEvaluator(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public Object visit(Literal expression, Object extraData) {
        Object value = expression.getValue();
        if (value instanceof Geometry) {
            Geometry g = (Geometry)value;
            if (g.getUserData() instanceof CoordinateReferenceSystem) {
                return g.getUserData();
            }
            if (g.getSRID() > 0) {
                try {
                    return CRS.decode((String)("EPSG:" + g.getSRID()));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public Object visit(Function expression, Object extraData) {
        for (Expression param : expression.getParameters()) {
            Object result = param.accept((ExpressionVisitor)this, extraData);
            if (!(result instanceof CoordinateReferenceSystem)) continue;
            return result;
        }
        return null;
    }

    public Object visit(PropertyName expression, Object extraData) {
        AttributeDescriptor ad = (AttributeDescriptor)expression.evaluate((Object)this.schema, AttributeDescriptor.class);
        if (ad == null) {
            throw new IllegalArgumentException("Original feature type does not have a property named " + expression.getPropertyName());
        }
        if (ad instanceof GeometryDescriptor) {
            return ((GeometryDescriptor)ad).getCoordinateReferenceSystem();
        }
        return null;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return null;
    }

    public Object visit(Add expression, Object extraData) {
        return null;
    }

    public Object visit(Divide expression, Object extraData) {
        return null;
    }

    public Object visit(Multiply expression, Object extraData) {
        return null;
    }

    public Object visit(Subtract expression, Object extraData) {
        return null;
    }
}

