/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.util.Arrays;
import java.util.List;
import org.geotools.data.transform.CRSEvaluator;
import org.geotools.data.transform.ExpressionTypeEvaluator;
import org.geotools.data.transform.TransformFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Definition {
    String name;
    Expression expression;
    Class binding;
    CoordinateReferenceSystem crs;
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public Definition(String name) {
        this(name, null, null);
    }

    public Definition(String name, Expression source) {
        this(name, source, null);
    }

    public Definition(String name, Expression source, Class binding) {
        this(name, source, binding, null);
    }

    public Definition(String name, Expression source, Class binding, CoordinateReferenceSystem crs) {
        this.name = name;
        this.expression = source == null ? TransformFeatureSource.FF.property(name) : source;
        this.binding = binding;
        this.crs = crs;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Class getBinding() {
        return this.binding;
    }

    public List<Definition> inverse() {
        if (this.expression instanceof PropertyName) {
            PropertyName pn = (PropertyName)this.expression;
            return Arrays.asList(new Definition(pn.getPropertyName(), (Expression)FF.property(this.name)));
        }
        return null;
    }

    public AttributeDescriptor getAttributeDescriptor(SimpleFeature originalFeature) {
        AttributeDescriptor ad = this.getAttributeDescriptor(originalFeature.getFeatureType());
        if (ad != null) {
            return ad;
        }
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        Object result = this.expression.evaluate((Object)originalFeature);
        Class<?> computedBinding = null;
        if (result != null) {
            computedBinding = result.getClass();
        }
        CoordinateReferenceSystem computedCRS = this.crs;
        if (Geometry.class.isAssignableFrom(computedBinding) && computedCRS == null) {
            computedCRS = this.evaluateCRS(originalFeature);
        }
        ab.setBinding(computedBinding);
        ab.setName(this.name);
        if (computedCRS != null) {
            ab.setCRS(computedCRS);
        }
        return ab.buildDescriptor(this.name);
    }

    public AttributeDescriptor getAttributeDescriptor(SimpleFeatureType originalSchema) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ExpressionTypeEvaluator typeEvaluator = new ExpressionTypeEvaluator(originalSchema);
        if (this.binding != null) {
            ab.setBinding(this.binding);
            ab.setName(this.name);
            if (this.crs != null) {
                ab.setCRS(this.crs);
            } else {
                this.expression.accept((ExpressionVisitor)typeEvaluator, null);
                ab.setCRS(typeEvaluator.getCoordinateReferenceSystem());
            }
            return ab.buildDescriptor(this.name);
        }
        if (this.expression instanceof PropertyName) {
            PropertyName pn = (PropertyName)this.expression;
            AttributeDescriptor descriptor = originalSchema.getDescriptor(pn.getPropertyName());
            if (descriptor == null) {
                throw new IllegalArgumentException("Original feature type does not have a property named " + this.name);
            }
            ab.init(descriptor);
            ab.setName(this.name);
            return ab.buildDescriptor(this.name);
        }
        Class computedBinding = (Class)this.expression.accept((ExpressionVisitor)typeEvaluator, null);
        if (computedBinding == null) {
            return null;
        }
        CoordinateReferenceSystem computedCRS = this.crs;
        if (Geometry.class.isAssignableFrom(computedBinding) && computedCRS == null) {
            computedCRS = this.evaluateCRS(originalSchema);
        }
        ab.setBinding(computedBinding);
        ab.setName(this.name);
        if (computedCRS != null) {
            ab.setCRS(computedCRS);
        }
        return ab.buildDescriptor(this.name);
    }

    private CoordinateReferenceSystem evaluateCRS(SimpleFeature originalFeature) {
        SimpleFeatureType originalSchema = originalFeature.getFeatureType();
        CoordinateReferenceSystem computedCRS = this.evaluateCRS(originalSchema);
        if (computedCRS == null) {
            Geometry g = (Geometry)this.expression.evaluate((Object)originalFeature, Geometry.class);
            if (g != null && g.getUserData() instanceof CoordinateReferenceSystem) {
                computedCRS = (CoordinateReferenceSystem)g.getUserData();
            } else if (g != null) {
                try {
                    computedCRS = CRS.decode((String)("EPSG:" + g.getSRID()));
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return computedCRS;
    }

    private CoordinateReferenceSystem evaluateCRS(SimpleFeatureType originalSchema) {
        return (CoordinateReferenceSystem)this.expression.accept((ExpressionVisitor)new CRSEvaluator(originalSchema), null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.binding == null ? 0 : this.binding.hashCode());
        result = 31 * result + (this.crs == null ? 0 : this.crs.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Definition other = (Definition)obj;
        if (this.binding == null ? other.binding != null : !this.binding.equals(other.binding)) {
            return false;
        }
        if (this.crs == null ? other.crs != null : !this.crs.equals(other.crs)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Definition [name=" + this.name + ", binding=" + this.binding + ", crs=" + this.crs + ", expression=" + this.expression + "]";
    }
}

