/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.transform.SimpleFeatureIteratorIterator;
import org.geotools.data.transform.TransformFeatureIteratorWrapper;
import org.geotools.data.transform.Transformer;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;

class TransformFeatureCollectionWrapper
extends AbstractFeatureCollection {
    FeatureCollection<SimpleFeatureType, SimpleFeature> wrapped;
    Transformer transformer;

    public TransformFeatureCollectionWrapper(FeatureCollection<SimpleFeatureType, SimpleFeature> wrapped, Transformer transformer) {
        super((SimpleFeatureType)wrapped.getSchema());
        this.wrapped = wrapped;
        this.transformer = transformer;
    }

    protected Iterator<SimpleFeature> openIterator() {
        try {
            return new SimpleFeatureIteratorIterator(new TransformFeatureIteratorWrapper((FeatureIterator<SimpleFeature>)this.wrapped.features(), this.transformer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.wrapped.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds() {
        List<String> names = this.transformer.getGeometryPropertyNames();
        if (names == null) {
            return null;
        }
        boolean geometryTransformed = false;
        for (String name : names) {
            Expression expression = this.transformer.getExpression(name);
            if (expression == null || expression instanceof PropertyName) continue;
            geometryTransformed = true;
        }
        if (!geometryTransformed) {
            return this.wrapped.getBounds();
        }
        ReferencedEnvelope re = null;
        try (SimpleFeatureIterator fi = null;){
            fi = this.features();
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                BoundingBox bb = f.getBounds();
                if (bb == null) continue;
                ReferencedEnvelope ref = ReferencedEnvelope.reference((Envelope)bb);
                if (re == null) {
                    re = ref;
                    continue;
                }
                re.expandToInclude((org.locationtech.jts.geom.Envelope)ref);
            }
            ReferencedEnvelope referencedEnvelope = re;
            return referencedEnvelope;
        }
    }
}

