/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.List;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFeatureStore;

public class TransformFeatureLocking
extends TransformFeatureStore
implements SimpleFeatureLocking {
    private final SimpleFeatureLocking locking;

    public TransformFeatureLocking(SimpleFeatureLocking locking, Name name, List<Definition> definitions) throws IOException {
        super((SimpleFeatureStore)locking, name, definitions);
        this.locking = locking;
    }

    public void setFeatureLock(FeatureLock lock) {
        this.locking.setFeatureLock(lock);
    }

    public int lockFeatures(Query query) throws IOException {
        Query txQuery = this.transformer.transformQuery(query);
        return this.locking.lockFeatures(txQuery);
    }

    public int lockFeatures(Filter filter) throws IOException {
        Filter txFilter = this.transformer.transformFilter(filter);
        return this.locking.lockFeatures(txFilter);
    }

    public int lockFeatures() throws IOException {
        return this.locking.lockFeatures();
    }

    public void unLockFeatures() throws IOException {
        this.locking.unLockFeatures();
    }

    public void unLockFeatures(Filter filter) throws IOException {
        Filter txFilter = this.transformer.transformFilter(filter);
        this.locking.unLockFeatures(txFilter);
    }

    public void unLockFeatures(Query query) throws IOException {
        Query txQuery = this.transformer.transformQuery(query);
        this.locking.unLockFeatures(txQuery);
    }
}

