/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.transform.Transformer;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.logging.Logging;

class TransformFeatureReaderWrapper
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    static final Logger LOGGER = Logging.getLogger(TransformFeatureReaderWrapper.class);
    private SimpleFeatureBuilder fb;
    private FeatureReader<SimpleFeatureType, SimpleFeature> wrapped;
    private Transformer transformer;
    private SimpleFeatureType target;

    public TransformFeatureReaderWrapper(FeatureReader<SimpleFeatureType, SimpleFeature> wrapped, Transformer transformer) throws IOException {
        this.transformer = transformer;
        this.target = transformer.getSchema();
        this.wrapped = wrapped;
        this.fb = new SimpleFeatureBuilder(this.target);
    }

    public boolean hasNext() throws IOException {
        return this.wrapped.hasNext();
    }

    public SimpleFeature next() throws IOException {
        SimpleFeature f = (SimpleFeature)this.wrapped.next();
        for (AttributeDescriptor ad : this.target.getAttributeDescriptors()) {
            Expression ex = this.transformer.getExpression(ad.getLocalName());
            if (ex != null) {
                Object value = ex.evaluate((Object)f, ad.getType().getBinding());
                this.fb.add(value);
                continue;
            }
            this.fb.add(null);
        }
        return this.fb.buildFeature(this.transformer.transformFid(f));
    }

    public void close() throws IOException {
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        this.wrapped = null;
    }

    public SimpleFeatureType getFeatureType() {
        return this.target;
    }
}

