/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.transform.DefaultResourceInfo;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.SingleFeatureSourceDataStore;
import org.geotools.data.transform.TransformFeatureCollection;
import org.geotools.data.transform.Transformer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class TransformFeatureSource
implements SimpleFeatureSource {
    protected static final Logger LOGGER = Logging.getLogger(TransformFeatureSource.class);
    protected static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    protected Transformer transformer;
    protected SimpleFeatureSource source;

    public TransformFeatureSource(SimpleFeatureSource source, Name name, List<Definition> definitions) throws IOException {
        this.transformer = new Transformer(source, name, definitions, null);
        this.source = source;
        LOGGER.log(Level.FINE, "Transformed target schema for this feature source is {0}", this.transformer.getSchema());
    }

    public Name getName() {
        return this.transformer.getName();
    }

    public ResourceInfo getInfo() {
        return new DefaultResourceInfo((FeatureSource)this);
    }

    public DataAccess<SimpleFeatureType, SimpleFeature> getDataStore() {
        return new SingleFeatureSourceDataStore(this);
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities(){

            public boolean isOffsetSupported() {
                return true;
            }

            public boolean isReliableFIDSupported() {
                return TransformFeatureSource.this.source.getQueryCapabilities().isReliableFIDSupported();
            }

            public boolean isJoiningSupported() {
                return false;
            }

            public boolean isUseProvidedFIDSupported() {
                return TransformFeatureSource.this.source.getQueryCapabilities().isUseProvidedFIDSupported();
            }

            public boolean isVersionSupported() {
                return TransformFeatureSource.this.source.getQueryCapabilities().isVersionSupported();
            }

            public boolean supportsSorting(SortBy[] sortAttributes) {
                for (SortBy sortBy : sortAttributes) {
                    if (sortBy == SortBy.NATURAL_ORDER || sortBy == SortBy.REVERSE_ORDER) continue;
                    String pn = sortBy.getPropertyName().getPropertyName();
                    AttributeDescriptor descriptor = TransformFeatureSource.this.transformer.getSchema().getDescriptor(pn);
                    if (descriptor == null) {
                        return false;
                    }
                    Class binding = descriptor.getType().getBinding();
                    if (Comparable.class.isAssignableFrom(binding)) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Can't sort on {0} because its property type {1} is not comparable", new Object[]{descriptor.getLocalName(), binding});
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException("We don't support feature listeners at the moment");
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException("We don't support feature listeners at the moment");
    }

    public SimpleFeatureType getSchema() {
        return this.transformer.getSchema();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        List<String> geometryNames = this.transformer.getGeometryPropertyNames();
        List<String> filtered = this.getSelectedAttributes(geometryNames, query);
        if (filtered.isEmpty()) {
            LOGGER.log(Level.FINE, "No geometry properties in query {0}", query);
            return null;
        }
        List<String> originalNames = this.transformer.getOriginalNames(filtered);
        if (originalNames.size() < filtered.size()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Some of the geometry attributes is the result of a general transformation (not a rename), can't compute the bbox quickly");
            }
            return null;
        }
        Query txQuery = this.transformer.transformQuery(query);
        txQuery.setPropertyNames(originalNames);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "The original query for bounds computation{0} has been tranformed to {1}", new Object[]{query, txQuery});
        }
        return this.source.getBounds(txQuery);
    }

    private List<String> getSelectedAttributes(List<String> attributeNames, Query query) {
        if (query.getPropertyNames() == null) {
            return attributeNames;
        }
        List<String> pnames = Arrays.asList(query.getPropertyNames());
        ArrayList<String> result = new ArrayList<String>();
        for (String an : attributeNames) {
            if (!pnames.contains(an)) continue;
            result.add(an);
        }
        return result;
    }

    public int getCount(Query query) throws IOException {
        Query txQuery = this.transformer.transformQuery(query);
        txQuery.setPropertyNames(Query.ALL_NAMES);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "The original query for count computation{0} has been transformed to {1}", new Object[]{query, txQuery});
        }
        return this.source.getCount(txQuery);
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        HashSet<RenderingHints.Key> hints = new HashSet<RenderingHints.Key>();
        hints.addAll(this.source.getSupportedHints());
        hints.add((RenderingHints.Key)Hints.FEATURE_DETACHED);
        return hints;
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.transformer.getSchema().getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        return new TransformFeatureCollection(this, this.transformer, query);
    }
}

