/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFilterVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.util.logging.Logging;

class Transformer {
    static final Logger LOGGER = Logging.getLogger(Transformer.class);
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    SimpleFeatureSource source;
    Name name;
    List<Definition> definitions;
    Map<String, Expression> expressions;
    SimpleFeatureType schema;

    public Transformer(SimpleFeatureSource source, Name name, List<Definition> definitions, SimpleFeatureType targetSchema) throws IOException {
        this.source = source;
        this.name = name;
        this.definitions = definitions;
        this.expressions = new HashMap<String, Expression>();
        for (Definition property : definitions) {
            this.expressions.put(property.getName(), property.getExpression());
        }
        this.schema = targetSchema == null ? this.computeTargetSchema(name, definitions) : targetSchema;
    }

    List<String> getGeometryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor)) continue;
            result.add(ad.getLocalName());
        }
        return result;
    }

    private SimpleFeatureType computeTargetSchema(Name typeName, List<Definition> definitions) throws IOException {
        SimpleFeatureType target = this.computeTargetSchemaStatically((SimpleFeatureType)this.source.getSchema(), typeName, definitions);
        if (target != null) {
            return target;
        }
        SimpleFeature sample = null;
        try (SimpleFeatureIterator iterator = this.source.getFeatures().features();){
            if (iterator.hasNext()) {
                sample = (SimpleFeature)iterator.next();
            }
        }
        if (sample == null) {
            throw new IllegalStateException("Cannot compute the target feature type from the definitions by static analysis, and the source does not have any feature that we can use as a sample to compute the target type dynamically");
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        for (Definition definition : definitions) {
            AttributeDescriptor ad = definition.getAttributeDescriptor(sample);
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    private SimpleFeatureType computeTargetSchemaStatically(SimpleFeatureType originalSchema, Name typeName, List<Definition> definitions) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        for (Definition definition : definitions) {
            AttributeDescriptor ad = definition.getAttributeDescriptor(originalSchema);
            if (ad == null) {
                return null;
            }
            tb.add(ad);
        }
        return tb.buildFeatureType();
    }

    String transformFid(SimpleFeature sourceFeature) {
        String origFidPrefix;
        String origFid = sourceFeature.getID();
        if (origFid.startsWith(origFidPrefix = sourceFeature.getType().getTypeName() + ".")) {
            String id = origFid.substring(origFidPrefix.length());
            return this.schema.getTypeName() + "." + id;
        }
        return origFid;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    Expression getExpression(String attributeName) {
        return this.expressions.get(attributeName);
    }

    public Name getName() {
        return this.name;
    }

    public SimpleFeatureSource getSource() {
        return this.source;
    }

    public List<String> getOriginalNames(List<String> names) {
        ArrayList<String> originalNames = new ArrayList<String>();
        for (String name : names) {
            Expression ex = this.expressions.get(name);
            if (ex instanceof PropertyName) {
                PropertyName pn = (PropertyName)ex;
                originalNames.add(pn.getPropertyName());
                continue;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "The attribute {0} has a general transformation {1}, can't associate it with an original attribute name ", new Object[]{name, ex});
        }
        return originalNames;
    }

    Filter transformFilter(Filter filter) {
        TransformFilterVisitor transformer = new TransformFilterVisitor(((SimpleFeatureType)this.source.getSchema()).getTypeName(), this.name.getLocalPart(), this.expressions);
        return (Filter)filter.accept((FilterVisitor)transformer, null);
    }

    Expression transformExpression(Expression expression) {
        TransformFilterVisitor transformer = new TransformFilterVisitor(((SimpleFeatureType)this.source.getSchema()).getTypeName(), this.name.getLocalPart(), this.expressions);
        return (Expression)expression.accept((ExpressionVisitor)transformer, null);
    }

    Query transformQuery(Query query) {
        Filter txFilter = this.transformFilter(query.getFilter());
        Query txQuery = new Query(query);
        txQuery.setTypeName(((SimpleFeatureType)this.source.getSchema()).getTypeName());
        txQuery.setPropertyNames(this.getRequiredAttributes(query));
        txQuery.setSortBy(this.getTransformedSortBy(query));
        txQuery.setFilter(txFilter);
        txQuery.setCoordinateSystem(query.getCoordinateSystem());
        txQuery.setCoordinateSystemReproject(query.getCoordinateSystemReproject());
        QueryCapabilities caps = this.source.getQueryCapabilities();
        if (query.getSortBy() != null && !caps.supportsSorting(txQuery.getSortBy())) {
            txQuery.setSortBy(null);
        }
        if (query.getSortBy() != null && txQuery.getSortBy() == null) {
            txQuery.setStartIndex(null);
            txQuery.setMaxFeatures(Integer.MAX_VALUE);
        }
        if (!caps.isOffsetSupported()) {
            txQuery.setStartIndex(null);
            txQuery.setMaxFeatures(Integer.MAX_VALUE);
        }
        return txQuery;
    }

    SortBy[] getTransformedSortBy(Query query) {
        SortBy[] original = query.getSortBy();
        if (original == null) {
            return original;
        }
        ArrayList<SortBy> transformed = new ArrayList<SortBy>();
        for (SortBy sort : original) {
            if (sort == SortBy.NATURAL_ORDER || sort == SortBy.REVERSE_ORDER) {
                transformed.add(sort);
                continue;
            }
            PropertyName pname = sort.getPropertyName();
            Expression ex = this.expressions.get(pname.getPropertyName());
            if (ex == null) {
                throw new IllegalArgumentException("Attribute " + pname + " is not part of the output schema");
            }
            if (ex instanceof PropertyName) {
                PropertyName pn = (PropertyName)ex;
                transformed.add(FF.sort(pn.getPropertyName(), sort.getSortOrder()));
                continue;
            }
            if (ex instanceof Literal) continue;
            return null;
        }
        return transformed.toArray(new SortBy[transformed.size()]);
    }

    String[] getRequiredAttributes(Query query) {
        HashSet attributes = new HashSet();
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        if (query.getPropertyNames() == Query.ALL_NAMES) {
            for (Expression ex : this.expressions.values()) {
                ex.accept((ExpressionVisitor)extractor, null);
            }
        } else {
            for (String name : query.getPropertyNames()) {
                Expression ex = this.expressions.get(name);
                ex.accept((ExpressionVisitor)extractor, null);
            }
        }
        attributes.addAll(extractor.getAttributeNameSet());
        return attributes.toArray(new String[attributes.size()]);
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public String toString() {
        return "Transformer[ feature source= " + this.source + " , type=" + this.source.getSchema() + ", definitions=" + this.definitions;
    }
}

