/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.Map;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LinePolygonAbstractValidation;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class LineCoveredByPolygonBoundaryValidation
extends LinePolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        SimpleFeatureSource fsLine = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        SimpleFeatureCollection fcLine = fsLine.getFeatures();
        try (SimpleFeatureIterator fLine = fcLine.features();){
            SimpleFeatureSource fsPoly = (SimpleFeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
            ListFeatureCollection fcPoly = new ListFeatureCollection(fsPoly.getFeatures());
            while (fLine.hasNext()) {
                SimpleFeature line = (SimpleFeature)fLine.next();
                SimpleFeatureIterator fPoly = fcPoly.features();
                try {
                    Geometry lineGeom = (Geometry)line.getDefaultGeometry();
                    if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
                    if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                        while (fPoly.hasNext()) {
                            SimpleFeature poly = (SimpleFeature)fPoly.next();
                            Geometry polyGeom = (Geometry)poly.getDefaultGeometry();
                            if (envelope.contains(polyGeom.getEnvelopeInternal())) {
                                if (Polygon.class.isAssignableFrom(polyGeom.getClass())) {
                                    Geometry polyGeomBoundary = polyGeom.getBoundary();
                                    if (polyGeomBoundary.contains(lineGeom)) continue;
                                    results.error(poly, "Boundary does not contain the specified Line.");
                                    r = false;
                                    continue;
                                }
                                fcPoly.remove((Object)poly);
                                results.warning(poly, "Invalid type: this feature is not a derivative of a Polygon");
                                continue;
                            }
                            fcPoly.remove((Object)poly);
                        }
                        continue;
                    }
                    results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
                }
                finally {
                    if (fPoly == null) continue;
                    fPoly.close();
                }
            }
        }
        return r;
    }

    @Override
    public int getPriority() {
        return 200;
    }
}

