/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import java.util.Map;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineAbstractValidation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;

public class LineNoPseudoNodeValidation
extends LineAbstractValidation {
    private int degreesAllowable;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        SimpleFeatureSource fsLine = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        SimpleFeatureCollection fcLine = fsLine.getFeatures();
        try (SimpleFeatureIterator fLine = fcLine.features();){
            block5: while (fLine.hasNext()) {
                SimpleFeature line = (SimpleFeature)fLine.next();
                Geometry lineGeom = (Geometry)line.getDefaultGeometry();
                if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
                if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                    Coordinate[] c = lineGeom.getCoordinates();
                    int i = 0;
                    while (true) {
                        if (i + 2 >= c.length) continue block5;
                        LineSegment ls1 = new LineSegment(c[i], c[i + 1]);
                        LineSegment ls2 = new LineSegment(c[i + 1], c[i + 2]);
                        double a1 = ls1.angle();
                        double a2 = ls2.angle();
                        if (a1 - (double)this.degreesAllowable < a1 && a1 + (double)this.degreesAllowable > a2) continue;
                        results.error(line, "Atleast one node was too close to the other the perpendicular line between the node's two neighbours.");
                        i = c.length;
                    }
                }
                results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
            }
            return r;
        }
    }

    public int getDegreesAllowable() {
        return this.degreesAllowable;
    }

    public void setDegreesAllowable(int degreesAllowable) {
        this.degreesAllowable = degreesAllowable;
    }
}

