/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Repository;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentState;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.vectormosaic.AttributeRenameVisitor;
import org.geotools.vectormosaic.FilterTracker;
import org.geotools.vectormosaic.GranuleSourceProvider;
import org.geotools.vectormosaic.GranuleStoreFinder;
import org.geotools.vectormosaic.GranuleStoreFinderImpl;
import org.geotools.vectormosaic.VectorMosaicFeatureReader;
import org.geotools.vectormosaic.VectorMosaicGranule;
import org.geotools.vectormosaic.VectorMosaicPostPreFilterSplitter;
import org.geotools.vectormosaic.VectorMosaicState;
import org.geotools.vectormosaic.VectorMosaicStore;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class VectorMosaicFeatureSource
extends ContentFeatureSource {
    static final Logger LOGGER = Logging.getLogger(VectorMosaicFeatureSource.class);
    private static final Pattern STORE_NAME_REGEX = Pattern.compile("^(?!.*=)(?!.*(?:\\/|\\.|\\w+:\\w+)).*$", 32);
    private final Repository repository;
    private final String delegateStoreTypeName;
    private final String delegateStoreName;
    private final String preferredSPI;
    private final String connectionParameterKey;
    protected ContentState state;
    protected FilterTracker filterTracker = new FilterTracker();
    protected GranuleStoreFinder finder;

    public VectorMosaicFeatureSource(ContentEntry contentEntry, VectorMosaicStore store) {
        super(contentEntry, null);
        this.delegateStoreTypeName = StringUtils.removeEnd((String)contentEntry.getName().getLocalPart(), (String)"_mosaic");
        this.repository = store.getRepository();
        this.delegateStoreName = store.getDelegateStoreName();
        this.preferredSPI = store.getPreferredSPI();
        this.finder = new GranuleStoreFinderImpl(this.preferredSPI, this.repository);
        this.connectionParameterKey = store.getConnectionParameterKey();
    }

    public VectorMosaicStore getStore() {
        return (VectorMosaicStore)this.getEntry().getDataStore();
    }

    protected Filter getSplitFilter(Query query, DataStore dataStore, String typeName, boolean isDelegate) {
        Filter originalFilter = query.getFilter();
        try {
            SimpleFeatureType indexFeatureType = dataStore.getSchema(typeName);
            VectorMosaicPostPreFilterSplitter splitter = new VectorMosaicPostPreFilterSplitter(indexFeatureType);
            if (isDelegate) {
                String source = indexFeatureType.getGeometryDescriptor().getLocalName();
                String target = this.getSchema().getGeometryDescriptor().getLocalName();
                AttributeRenameVisitor renameVisitor = new AttributeRenameVisitor(target, source);
                Filter renamedFilter = (Filter)originalFilter.accept((FilterVisitor)renameVisitor, null);
                renamedFilter.accept((FilterVisitor)splitter, null);
                this.filterTracker.setDelegateFilter(splitter.getFilterPre());
            } else {
                originalFilter.accept((FilterVisitor)splitter, null);
                this.filterTracker.setGranuleFilter(splitter.getFilterPre());
            }
            return splitter.getFilterPre();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not get schema for " + typeName, e);
            return originalFilter;
        }
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        Name dsname = VectorMosaicStore.buildName(this.delegateStoreName);
        DataStore delegateDataStore = this.repository.dataStore(dsname);
        Filter splitFilter = this.getSplitFilter(query, delegateDataStore, this.delegateStoreTypeName, true);
        SimpleFeatureSource featureSource = delegateDataStore.getFeatureSource(this.delegateStoreTypeName);
        if (splitFilter != Filter.INCLUDE) {
            query.setFilter(splitFilter);
        }
        return this.getReferenceEnvelopeMaybeManually((FeatureSource)featureSource, query);
    }

    private ReferencedEnvelope getReferenceEnvelopeMaybeManually(FeatureSource source, Query boundsQuery) throws IOException {
        ReferencedEnvelope bounds = null;
        bounds = source.getBounds(boundsQuery);
        if (bounds == null) {
            bounds = new ReferencedEnvelope(source.getSchema().getCoordinateReferenceSystem());
            try (SimpleFeatureIterator features = (SimpleFeatureIterator)source.getFeatures(boundsQuery).features();){
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    bounds.expandToInclude((Envelope)((ReferencedEnvelope)feature.getBounds()));
                }
            }
        }
        return bounds;
    }

    protected int getCountInternal(Query query) throws IOException {
        int count = 0;
        SimpleFeatureCollection features = this.getDelegateFeatures(query);
        try (GranuleSourceProvider provider = new GranuleSourceProvider(this, features, query);){
            SimpleFeatureSource source;
            while ((source = provider.getNextGranuleSource()) != null) {
                Query granuleQuery = provider.getGranuleQuery();
                int granuleCount = source.getCount(granuleQuery);
                if (granuleCount < 0) {
                    granuleCount = source.getFeatures(granuleQuery).size();
                }
                count += granuleCount;
            }
        }
        return count;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        SimpleFeatureCollection features = this.getDelegateFeatures(query);
        GranuleSourceProvider granuleSources = new GranuleSourceProvider(this, features, query);
        VectorMosaicFeatureReader reader = new VectorMosaicFeatureReader(granuleSources, this);
        return reader;
    }

    private SimpleFeatureCollection getDelegateFeatures(Query query) throws IOException {
        Name dsname = VectorMosaicStore.buildName(this.delegateStoreName);
        DataStore delegateDataStore = this.repository.dataStore(dsname);
        Filter splitFilterIndex = this.getSplitFilter(query, delegateDataStore, this.delegateStoreTypeName, true);
        SimpleFeatureSource delegateFeatureSource = delegateDataStore.getFeatureSource(this.delegateStoreTypeName);
        Query delegateQuery = new Query(this.delegateStoreTypeName, splitFilterIndex);
        if (query.getPropertyNames() != Query.ALL_NAMES) {
            String[] filteredArray = VectorMosaicFeatureSource.getOnlyTypeMatchingAttributes(delegateDataStore, this.delegateStoreTypeName, query, true);
            delegateQuery.setPropertyNames(filteredArray);
        }
        SimpleFeatureCollection features = delegateFeatureSource.getFeatures(delegateQuery);
        return features;
    }

    static String[] getOnlyTypeMatchingAttributes(DataStore typeStore, String typeName, Query query, boolean isDelegate) throws IOException {
        SimpleFeatureType featureType = typeStore.getSchema(typeName);
        Set<String> attributeNames = VectorMosaicFeatureSource.getAttributeNamesForType(featureType);
        LinkedHashSet<String> queryNames = new LinkedHashSet<String>(Arrays.asList(query.getPropertyNames()));
        if (query.getFilter() != null) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(featureType);
            query.getFilter().accept((FilterVisitor)extractor, null);
            queryNames.addAll(Arrays.asList(extractor.getAttributeNames()));
        }
        List filteredAttributes = queryNames.stream().filter(attributeNames::contains).collect(Collectors.toList());
        if (isDelegate) {
            for (String field : VectorMosaicGranule.GRANULE_CONFIG_FIELDS) {
                if (!attributeNames.contains(field) || filteredAttributes.contains(field)) continue;
                filteredAttributes.add(field);
            }
        }
        return (String[])filteredAttributes.toArray(String[]::new);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        Name dsname = VectorMosaicStore.buildName(this.delegateStoreName);
        DataStore delegateDataStore = this.repository.dataStore(dsname);
        SimpleFeatureType indexFeatureType = delegateDataStore.getSchema(this.delegateStoreTypeName);
        SimpleFeatureType granuleFeatureType = this.getGranuleType();
        return this.getFeatureType(indexFeatureType, granuleFeatureType);
    }

    public ContentState getState() {
        if (this.state != null) {
            return this.state;
        }
        return super.getState();
    }

    protected SimpleFeatureType getGranuleType() throws IOException {
        VectorMosaicState state = (VectorMosaicState)this.getState();
        if (state.getGranuleFeatureType() != null) {
            return state.getGranuleFeatureType();
        }
        Name dsname = VectorMosaicStore.buildName(this.delegateStoreName);
        DataStore delegateDataStore = this.repository.dataStore(dsname);
        SimpleFeatureSource delegateFeatureSource = delegateDataStore.getFeatureSource(this.delegateStoreTypeName);
        Query q = new Query(((SimpleFeatureType)delegateFeatureSource.getSchema()).getTypeName());
        q.setMaxFeatures(1);
        SimpleFeatureCollection features = delegateFeatureSource.getFeatures(q);
        SimpleFeature firstDelegateFeature = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
        if (firstDelegateFeature == null) {
            throw new IOException("No index features found in " + this.delegateStoreName);
        }
        VectorMosaicGranule granule = VectorMosaicGranule.fromDelegateFeature(firstDelegateFeature);
        DataStore granuleDataStore = this.initGranule(granule, true);
        SimpleFeatureType granuleFeatureType = null;
        try {
            granuleFeatureType = granuleDataStore.getSchema(granule.getGranuleTypeName());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not get schema for " + granule.getGranuleTypeName(), e);
            throw new IOException("Could not get schema for " + granule.getGranuleTypeName(), e);
        }
        finally {
            if (granuleDataStore != null) {
                granuleDataStore.dispose();
            }
        }
        state.setGranuleFeatureType(granuleFeatureType);
        return granuleFeatureType;
    }

    protected SimpleFeatureType getFeatureType(SimpleFeatureType indexFeatureType, SimpleFeatureType granuleFeatureType) throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(granuleFeatureType);
        tb.setName(this.delegateStoreTypeName + "_mosaic");
        tb.setNamespaceURI(this.getStore().getNamespaceURI());
        for (AttributeDescriptor descriptor : indexFeatureType.getAttributeDescriptors()) {
            if (!this.isNotMandatoryIndexType(descriptor)) continue;
            tb.add(descriptor);
        }
        this.schema = tb.buildFeatureType();
        return this.schema;
    }

    protected boolean isNotMandatoryIndexType(AttributeDescriptor descriptor) {
        String name = descriptor.getLocalName();
        return !"params".equals(name) && !"type".equals(name) && !"filter".equals(name) && !(descriptor.getType() instanceof GeometryType) && !name.equals("id");
    }

    public DataStore initGranule(VectorMosaicGranule granule, boolean isSampleForType) throws IOException {
        DataStore dataStore = null;
        this.setupGranuleStore(granule);
        Optional<DataStore> dataStoreOptional = this.finder.findDataStore(granule, isSampleForType);
        dataStore = dataStoreOptional.orElseThrow(() -> new IOException("No data store found for granule"));
        this.populateGranuleTypeName(granule, dataStore);
        return dataStore;
    }

    private DataStore getDataStoreByName(String typeName) {
        Name dsname = VectorMosaicStore.buildName(typeName);
        return this.repository.dataStore(dsname);
    }

    private Set<String> getAttributeNamesForType(String storeName, String typeName) throws IOException {
        DataStore dataStore = this.getDataStoreByName(storeName);
        SimpleFeatureType featureType = dataStore.getSchema(typeName);
        return VectorMosaicFeatureSource.getAttributeNamesForType(featureType);
    }

    public static Set<String> getAttributeNamesForType(SimpleFeatureType featureType) throws IOException {
        return featureType.getAttributeDescriptors().stream().map(AttributeDescriptor::getLocalName).collect(Collectors.toSet());
    }

    private boolean allFilterAttributesAreInType(String storeName, String typeName, Filter filter) throws IOException {
        Set<String> indexAttributeNames = this.getAttributeNamesForType(storeName, typeName);
        String[] filterAttributeNames = DataUtilities.attributeNames((Filter)filter);
        return indexAttributeNames.containsAll(Arrays.asList(filterAttributeNames));
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        if (visitor instanceof MaxVisitor || visitor instanceof MinVisitor || visitor instanceof UniqueVisitor || visitor instanceof NearestVisitor) {
            Set<String> indexAttributeNames = this.getAttributeNamesForType(this.delegateStoreName, this.delegateStoreTypeName);
            if (query.getFilter() != null && !this.allFilterAttributesAreInType(this.delegateStoreName, this.delegateStoreTypeName, query.getFilter())) {
                return false;
            }
            List visitorExpressionFields = ((FeatureAttributeVisitor)visitor).getExpressions().stream().map(DataUtilities::attributeNames).flatMap(Arrays::stream).collect(Collectors.toList());
            if (!indexAttributeNames.containsAll(visitorExpressionFields)) {
                return false;
            }
            query.setPropertyNames(visitorExpressionFields);
            DataStore delegateDataStore = this.getDataStoreByName(this.delegateStoreName);
            delegateDataStore.getFeatureSource(this.delegateStoreTypeName).getFeatures(query).accepts(visitor, null);
            return true;
        }
        return false;
    }

    protected void populateGranuleTypeName(VectorMosaicGranule granule, DataStore dataStore) throws IOException {
        if (granule.getGranuleTypeName() == null || granule.getGranuleTypeName().isEmpty()) {
            String[] typeNames = dataStore.getTypeNames();
            if (typeNames.length > 0) {
                granule.setGranuleTypeName(typeNames[0]);
            } else {
                throw new IOException("No type names found in the granule data store");
            }
        }
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canFilter() {
        return true;
    }

    private void setupGranuleStore(VectorMosaicGranule granule) {
        Properties connProps = new Properties();
        String params = granule.getParams();
        if (STORE_NAME_REGEX.matcher(params).matches()) {
            granule.setStoreName(params);
            return;
        }
        try {
            if (this.isURI(params)) {
                connProps.put(this.connectionParameterKey, this.toConnectionParameter(this.connectionParameterKey, params));
            } else {
                connProps.load(new StringReader(params));
            }
        }
        catch (IOException e) {
            connProps.put(this.connectionParameterKey, this.toConnectionParameter(this.connectionParameterKey, granule.getParams()));
        }
        granule.setConnProperties(connProps);
    }

    private boolean isURI(String connectionString) {
        return connectionString.startsWith("file:") || connectionString.startsWith("http:") || connectionString.startsWith("https:");
    }

    private Object toConnectionParameter(String connectionParameterKey, String params) {
        if (connectionParameterKey.equals("url")) {
            try {
                return new URL(params);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid connection parameter", e);
            }
        }
        if (connectionParameterKey.equals("file")) {
            return new File(params);
        }
        return params;
    }
}

