/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.Serializable;
import java.util.Properties;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class VectorMosaicGranule
implements Serializable {
    public static final String CONNECTION_PARAMETERS_DELEGATE_FIELD_DEFAULT = "params";
    public static final String GRANULE_TYPE_NAME = "type";
    public static final String GRANULE_FILTER = "filter";
    public static final String GRANULE_ID_FIELD = "id";
    public static final String[] GRANULE_CONFIG_FIELDS = new String[]{"params", "filter", "type"};
    String name;
    String granuleTypeName;
    String params;
    Properties connProperties;
    String storeName;
    Filter filter;

    public static VectorMosaicGranule fromDelegateFeature(SimpleFeature delegateFeature) {
        String filterAttribute;
        VectorMosaicGranule config = new VectorMosaicGranule();
        config.params = (String)delegateFeature.getAttribute(CONNECTION_PARAMETERS_DELEGATE_FIELD_DEFAULT);
        if (delegateFeature.getAttribute(GRANULE_TYPE_NAME) != null) {
            config.granuleTypeName = (String)delegateFeature.getAttribute(GRANULE_TYPE_NAME);
        }
        if ((filterAttribute = (String)delegateFeature.getAttribute(GRANULE_FILTER)) != null && !filterAttribute.isEmpty()) {
            try {
                config.filter = ECQL.toFilter((String)filterAttribute);
            }
            catch (CQLException e) {
                throw new IllegalArgumentException("Failed to parse filter: " + filterAttribute);
            }
        }
        return config;
    }

    public String getGranuleTypeName() {
        return this.granuleTypeName;
    }

    public void setGranuleTypeName(String granuleTypeName) {
        this.granuleTypeName = granuleTypeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Properties getConnProperties() {
        return this.connProperties;
    }

    public void setConnProperties(Properties connProperties) {
        this.connProperties = connProperties;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
}

