/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vectormosaic;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.util.logging.Logging;
import org.geotools.vectormosaic.GranuleSourceProvider;
import org.geotools.vectormosaic.VectorMosaicFeatureSource;

class VectorMosaicFeatureReader
implements SimpleFeatureReader {
    static final Logger LOGGER = Logging.getLogger(VectorMosaicFeatureReader.class);
    private final VectorMosaicFeatureSource source;
    private final SimpleFeatureType internalSchema;
    private final GranuleSourceProvider granuleSourceProvider;
    private final Query query;
    private SimpleFeatureType targetSchema;
    private SimpleFeatureBuilder builder;
    private SimpleFeatureBuilder retypeBuilder;
    FeatureIterator delegateIterator;
    FeatureIterator granuleIterator;
    protected SimpleFeature nextGranule = null;
    protected SimpleFeature delegateFeature = null;
    protected SimpleFeature rawGranule = null;

    public VectorMosaicFeatureReader(GranuleSourceProvider granuleSourceProvider, VectorMosaicFeatureSource vectorMosaicFeatureSource) {
        this.granuleSourceProvider = granuleSourceProvider;
        this.source = vectorMosaicFeatureSource;
        this.query = granuleSourceProvider.getQuery();
        this.targetSchema = this.internalSchema = this.retype(this.source.getSchema(), this.query);
        this.builder = new SimpleFeatureBuilder(this.internalSchema);
        if (this.query.getPropertyNames() != null) {
            this.targetSchema = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.internalSchema, (String[])this.query.getPropertyNames());
            if (!this.internalSchema.equals(this.targetSchema)) {
                this.retypeBuilder = new SimpleFeatureBuilder(this.targetSchema);
            }
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.targetSchema;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature f = null;
        if (this.hasNext()) {
            f = this.nextGranule;
            this.nextGranule = null;
            return f;
        }
        throw new NoSuchElementException("No more features");
    }

    public boolean hasNext() throws IOException {
        if (this.nextGranule != null) {
            return true;
        }
        if (this.granuleIterator != null && this.delegateFeature != null) {
            while (this.granuleIterator.hasNext()) {
                this.nextGranule = this.readNext();
                if (this.nextGranule == null) continue;
                return true;
            }
        }
        SimpleFeatureSource granuleSource = null;
        while ((granuleSource = this.granuleSourceProvider.getNextGranuleSource()) != null) {
            this.delegateFeature = this.granuleSourceProvider.getDelegateFeature();
            Query granuleQuery = this.granuleSourceProvider.getGranuleQuery();
            this.granuleIterator = granuleSource.getFeatures(granuleQuery).features();
            while (this.granuleIterator.hasNext()) {
                this.nextGranule = this.readNext();
                if (this.nextGranule == null) continue;
                return true;
            }
            if (this.nextGranule != null) continue;
            this.granuleIterator.close();
        }
        this.close();
        return false;
    }

    private SimpleFeature readNext() {
        this.rawGranule = (SimpleFeature)this.granuleIterator.next();
        SimpleFeature peek = this.mergeGranuleAndDelegate(this.rawGranule, this.delegateFeature);
        if (this.query.getFilter().evaluate((Object)peek)) {
            if (this.retypeBuilder != null) {
                return SimpleFeatureBuilder.retype((SimpleFeature)peek, (SimpleFeatureBuilder)this.retypeBuilder);
            }
            return peek;
        }
        return null;
    }

    private SimpleFeature mergeGranuleAndDelegate(SimpleFeature peekGranule, SimpleFeature delegateFeature) {
        peekGranule.getType().getAttributeDescriptors().stream().filter(ad1 -> this.internalSchema.getDescriptor(ad1.getLocalName()) != null).map(ad1 -> ad1.getLocalName()).forEach(name1 -> this.builder.set(name1, peekGranule.getAttribute(name1)));
        delegateFeature.getType().getAttributeDescriptors().stream().filter(this.source::isNotMandatoryIndexType).filter(ad -> this.internalSchema.getDescriptor(ad.getLocalName()) != null).map(ad -> ad.getLocalName()).forEach(name -> this.builder.set(name, delegateFeature.getAttribute(name)));
        return this.builder.buildFeature(peekGranule.getID());
    }

    private SimpleFeatureType retype(SimpleFeatureType mergedType, Query query) {
        if (query == null || query.getPropertyNames() == Query.ALL_NAMES) {
            return mergedType;
        }
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(mergedType.getName());
        typeBuilder.setNamespaceURI(mergedType.getName().getNamespaceURI());
        HashSet<String> propertyNames = new HashSet<String>(Arrays.asList(query.getPropertyNames()));
        if (query.getFilter() != null) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            query.getFilter().accept((FilterVisitor)extractor, null);
            propertyNames.addAll(extractor.getAttributeNameSet());
        }
        boolean geomAdded = false;
        for (int i = 0; i < mergedType.getAttributeCount(); ++i) {
            String attributeName = mergedType.getDescriptor(i).getLocalName();
            if (!propertyNames.contains(attributeName)) continue;
            typeBuilder.add(mergedType.getDescriptor(i));
            if (!attributeName.equals(mergedType.getGeometryDescriptor().getLocalName())) continue;
            geomAdded = true;
        }
        if (geomAdded) {
            typeBuilder.setDefaultGeometry(mergedType.getGeometryDescriptor().getLocalName());
            typeBuilder.setCRS(mergedType.getCoordinateReferenceSystem());
        }
        return typeBuilder.buildFeatureType();
    }

    public void close() throws IOException {
        try {
            if (this.granuleIterator != null) {
                this.granuleIterator.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to close granule iterator", e);
        }
        try {
            if (this.granuleSourceProvider != null) {
                this.granuleSourceProvider.close();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to close granule source provider", e);
        }
    }
}

