/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import org.geotools.data.vpf.ColumnSet;
import org.geotools.data.vpf.TableRelation;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.readers.AreaGeometryFactory;
import org.geotools.data.vpf.readers.ConnectedNodeGeometryFactory;
import org.geotools.data.vpf.readers.EntityNodeGeometryFactory;
import org.geotools.data.vpf.readers.LineGeometryFactory;
import org.geotools.data.vpf.readers.TextGeometryFactory;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AnnotationFeatureType;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class VPFFeatureClass
implements SimpleFeatureType {
    private SimpleFeatureType featureType;
    private final List<VPFColumn> columns = new Vector<VPFColumn>();
    private final Map<String, ColumnSet> columnSet = new LinkedHashMap<String, ColumnSet>();
    private final Map<String, TableRelation> relations = new LinkedHashMap<String, TableRelation>();
    private final VPFCoverage coverage;
    private final String directoryName;
    private final String typeName;
    private final URI namespace;
    private VPFGeometryFactory geometryFactory;
    private boolean textTypeFeature = false;
    private boolean enableFeatureCache = true;
    private final List<SimpleFeature> featureCache = new ArrayList<SimpleFeature>();
    private int cacheRow = 0;
    private boolean debug = false;

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName) throws SchemaException {
        this(cCoverage, cName, cDirectoryName, null);
    }

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName, URI cNamespace) throws SchemaException {
        this.coverage = cCoverage;
        this.directoryName = cDirectoryName;
        this.typeName = cName;
        this.namespace = cNamespace == null ? VPFLibrary.DEFAULT_NAMESPACE : cNamespace;
        if (VPFLogger.isLoggable(Level.FINEST) && this.typeName.equalsIgnoreCase("VPFFEATURETYPE")) {
            this.debug = true;
        }
        String fcsFileName = this.directoryName + File.separator + "FCS";
        try {
            VPFFile fcsFile = VPFFileFactory.getInstance().getFile(fcsFileName);
            Iterator<SimpleFeature> iter = fcsFile.readAllRows().iterator();
            if (this.debug) {
                SimpleFeatureType fcsFeatureType = fcsFile.getFeatureType();
                VPFFeatureType.debugFeatureType(fcsFeatureType);
            }
            while (iter.hasNext()) {
                SimpleFeature feature = iter.next();
                String featureClassName = feature.getAttribute("feature_class").toString().trim();
                if (!this.typeName.equals(featureClassName)) continue;
                if (this.debug) {
                    VPFFeatureType.debugFeature(feature);
                }
                this.addFCS(feature);
            }
            this.assembleColumns();
            Iterator<VPFColumn> iter2 = this.columns.iterator();
            String geometryName = null;
            while (iter2.hasNext()) {
                VPFColumn column = iter2.next();
                if (column == null || !column.isGeometry()) continue;
                geometryName = column.getName();
                break;
            }
            SimpleFeatureType superType = null;
            if (this.textTypeFeature) {
                superType = AnnotationFeatureType.ANNOTATION;
            }
            if (this.debug) {
                VPFLogger.log("class col count: " + this.columns.size());
            }
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(cName);
            b.setNamespaceURI(this.namespace);
            b.setSuperType(superType);
            for (VPFColumn col : this.columns) {
                if (col == null) continue;
                b.add(col.getDescriptor());
            }
            b.setDefaultGeometry(geometryName);
            this.featureType = b.buildFeatureType();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void addFCS(SimpleFeature row) {
        String table1 = row.getAttribute("table1").toString().toUpperCase();
        String table1Key = row.getAttribute("table1_key").toString();
        String table2 = row.getAttribute("table2").toString().toUpperCase();
        String table2Key = row.getAttribute("table2_key").toString();
        if (this.debug) {
            VPFLogger.log("++++++++ addFCS");
            VPFLogger.log("table1: " + table1 + " key: " + table1Key);
            VPFLogger.log("table2: " + table2 + " key: " + table2Key);
        }
        try {
            VPFFile vpfFile1 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table1));
            if (!this.columnSet.containsKey(table1)) {
                ColumnSet cs = new ColumnSet();
                cs.setTable(table1, vpfFile1);
                this.columnSet.put(table1, cs);
            }
            ColumnSet cs1 = this.columnSet.get(table1);
            VPFFile vpfFile2 = null;
            VPFColumn joinColumn1 = vpfFile1.getColumn(table1Key);
            VPFColumn joinColumn2 = null;
            VPFColumn geometryColumn = null;
            boolean isGeometryTable = false;
            try {
                if (table2.equalsIgnoreCase("FAC")) {
                    geometryColumn = this.buildGeometryColumn(table2);
                    joinColumn2 = null;
                    isGeometryTable = true;
                } else {
                    vpfFile2 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table2));
                    joinColumn2 = vpfFile2.getColumn(table2Key);
                }
            }
            catch (IOException exc) {
                vpfFile2 = null;
                joinColumn2 = null;
                isGeometryTable = true;
                geometryColumn = this.buildGeometryColumn(table2);
            }
            if (!this.columnSet.containsKey(table2)) {
                ColumnSet cs = new ColumnSet();
                VPFGeometryFactory geometryFactory = isGeometryTable ? this.geometryFactory : null;
                cs.setTable(table2, vpfFile2);
                cs.setGeometry(isGeometryTable, geometryFactory, geometryColumn);
                this.columnSet.put(table2, cs);
            }
            ColumnSet cs2 = this.columnSet.get(table2);
            String relName = table1 + "_" + table1Key + "_" + table2 + "_" + table2Key;
            String relName2 = table2 + "_" + table2Key + "_" + table1 + "_" + table1Key;
            if (!this.relations.containsKey(relName) && !this.relations.containsKey(relName2)) {
                TableRelation tr = new TableRelation();
                tr.setTable(table2, cs2, table2Key, joinColumn2);
                tr.setJoinTable(table1, cs1, table1Key, joinColumn1);
                this.relations.put(relName, tr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void reset() {
        if (!this.enableFeatureCache || this.featureCache.size() == 0) {
            VPFFile rootTable;
            Iterator<Map.Entry<String, ColumnSet>> itr = this.columnSet.entrySet().iterator();
            Map.Entry<String, ColumnSet> first = itr.next();
            if (first == null) {
                return;
            }
            ColumnSet cs = first.getValue();
            VPFFile vPFFile = rootTable = cs != null ? cs.table : null;
            if (rootTable == null) {
                return;
            }
            cs.currRow = null;
            cs.geometry = null;
            while (itr.hasNext()) {
                Map.Entry<String, ColumnSet> next = itr.next();
                ColumnSet jcs = next.getValue();
                jcs.currRow = null;
                jcs.geometry = null;
            }
            rootTable.reset();
        }
        this.cacheRow = 0;
    }

    private synchronized void closeFiles() {
        for (Map.Entry<String, ColumnSet> next : this.columnSet.entrySet()) {
            ColumnSet cs = next.getValue();
            try {
                if (cs.table == null) continue;
                cs.table.close();
            }
            catch (IOException e) {
                VPFLogger.log("***** Exception when closing file");
                VPFLogger.log(cs.tableName);
                VPFLogger.log(cs.table.getPathName());
            }
        }
    }

    public synchronized boolean hasNext() {
        if (this.enableFeatureCache && this.featureCache.size() > 0) {
            return this.cacheRow < this.featureCache.size();
        }
        return this.internalHasNext();
    }

    private synchronized boolean internalHasNext() {
        VPFFile rootTable;
        Iterator<Map.Entry<String, ColumnSet>> itr = this.columnSet.entrySet().iterator();
        Map.Entry<String, ColumnSet> first = itr.next();
        if (first == null) {
            return false;
        }
        ColumnSet cs = first.getValue();
        VPFFile vPFFile = rootTable = cs != null ? cs.table : null;
        if (rootTable == null) {
            return false;
        }
        return rootTable.hasNext();
    }

    public synchronized List<SimpleFeature> readAllRows(SimpleFeatureType featureType) throws IOException {
        this.enableFeatureCache = true;
        this.featureCache.clear();
        this.reset();
        this.readNext(featureType);
        return this.featureCache;
    }

    public synchronized SimpleFeature readNext(SimpleFeatureType featureType) {
        SimpleFeature nextFeature = null;
        if (this.enableFeatureCache && this.featureCache.size() == 0) {
            this.reset();
            while (this.internalHasNext()) {
                SimpleFeature feature = this.joinRows(featureType);
                this.featureCache.add(feature);
            }
            if (this.featureCache.size() > 0) {
                this.closeFiles();
            }
        }
        if (this.enableFeatureCache) {
            if (this.cacheRow < this.featureCache.size()) {
                nextFeature = this.featureCache.get(this.cacheRow);
                ++this.cacheRow;
            } else {
                nextFeature = null;
            }
        } else {
            nextFeature = this.joinRows(featureType);
        }
        return nextFeature;
    }

    private synchronized void assembleColumns() {
        Iterator<Map.Entry<String, ColumnSet>> itr = this.columnSet.entrySet().iterator();
        this.columns.clear();
        while (itr.hasNext()) {
            Map.Entry<String, ColumnSet> next = itr.next();
            ColumnSet cs = next.getValue();
            if (cs.isGeometryTable) {
                this.columns.add(cs.geometryColumn);
                continue;
            }
            VPFFile vpfFile = cs.table;
            for (int inx = 0; inx < vpfFile.getAttributeCount(); ++inx) {
                VPFColumn col = vpfFile.getColumn(inx);
                String colName = col.getName();
                if (this.columns.size() > 0 && colName.equalsIgnoreCase("id")) continue;
                this.columns.add(col);
            }
        }
    }

    private synchronized SimpleFeature joinRows(SimpleFeatureType featureType) {
        VPFFile rootTable;
        Iterator<Map.Entry<String, ColumnSet>> itr = this.columnSet.entrySet().iterator();
        Map.Entry<String, ColumnSet> first = itr.next();
        if (first == null) {
            return null;
        }
        ColumnSet cs = first.getValue();
        VPFFile vPFFile = rootTable = cs != null ? cs.table : null;
        if (rootTable == null) {
            return null;
        }
        SimpleFeature row = null;
        try {
            row = rootTable.readFeature();
        }
        catch (Exception e) {
            row = null;
        }
        if (row == null) {
            return null;
        }
        cs.currRow = row;
        Object fid = row.getAttribute("id");
        String featureId = fid != null ? fid.toString() : UUID.randomUUID().toString();
        for (Map.Entry<String, TableRelation> next : this.relations.entrySet()) {
            Object foreignKeyValue;
            VPFFile foreignTable;
            TableRelation tr = next.getValue();
            String joinTableKeyName = tr.tableKeyName;
            ColumnSet jcs = tr.colSet;
            if (jcs == null) continue;
            VPFFile joinTable = jcs.table;
            jcs.currRow = null;
            String foreignTableKeyName = tr.joinTableKeyName;
            ColumnSet fcs = tr.joinColSet;
            if (fcs == null || fcs.currRow == null || (foreignTable = fcs.table) == null || (foreignKeyValue = fcs.currRow.getAttribute(foreignTableKeyName)) == null) continue;
            SimpleFeature jrow = null;
            if (jcs.isGeometryTable && jcs.geometryFactory != null) {
                Geometry geometry = null;
                try {
                    geometry = jcs.geometryFactory.buildGeometry(this, fcs.currRow);
                }
                catch (Exception e) {
                    geometry = null;
                    e.printStackTrace();
                }
                jcs.geometry = geometry;
            } else if (joinTable != null) {
                joinTable.reset();
                try {
                    Object joinKeyValue;
                    SimpleFeature nrow;
                    while (joinTable.hasNext() && (nrow = joinTable.readFeature()) != null && (joinKeyValue = nrow.getAttribute(joinTableKeyName)) != null) {
                        if (!Objects.equals(foreignKeyValue, joinKeyValue)) continue;
                        jrow = nrow;
                        break;
                    }
                }
                catch (Exception e) {
                    jrow = null;
                }
            }
            jcs.currRow = jrow;
        }
        return this.combineColumnSets(featureId, featureType);
    }

    private synchronized SimpleFeature combineColumnSets(String featureId, SimpleFeatureType featureType) {
        Iterator<Map.Entry<String, ColumnSet>> itr = this.columnSet.entrySet().iterator();
        Geometry geometry = null;
        ArrayList<Object> vlist = new ArrayList<Object>();
        while (itr.hasNext()) {
            Map.Entry<String, ColumnSet> next = itr.next();
            ColumnSet cs = next.getValue();
            if (cs.isGeometryTable) {
                geometry = cs.geometry;
                vlist.add(null);
                continue;
            }
            SimpleFeature row = cs.currRow;
            int colCount = cs.colNames.size();
            for (int inx = 0; inx < colCount; ++inx) {
                String colName = cs.colNames.get(inx);
                if (vlist.size() > 0 && colName.equalsIgnoreCase("id")) continue;
                Object value = row != null ? row.getAttribute(colName) : null;
                vlist.add(value);
            }
        }
        if (this.debug) {
            VPFFeatureType.debugFeatureType(this.featureType);
            VPFFeatureType.debugFeatureType(featureType);
        }
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, vlist, (String)featureId);
        if (geometry != null) {
            feature.setDefaultGeometry(geometry);
        }
        return feature;
    }

    private synchronized VPFColumn buildGeometryColumn(String table) {
        CoordinateReferenceSystem crs;
        AttributeDescriptor descriptor = null;
        table = table.trim().toUpperCase();
        if (this.debug) {
            VPFLogger.log("buildGeometryColumn: " + table);
        }
        descriptor = (crs = this.getCoverage().getLibrary().getCoordinateReferenceSystem()) != null ? new AttributeTypeBuilder().binding(Geometry.class).nillable(true).length(-1).crs(crs).buildDescriptor("GEOMETRY") : new AttributeTypeBuilder().binding(Geometry.class).nillable(true).buildDescriptor("GEOMETRY");
        VPFColumn result = new VPFColumn("GEOMETRY", descriptor);
        this.setGeometryFactory(table);
        return result;
    }

    private synchronized void setGeometryFactory(String table) {
        if (table.equalsIgnoreCase("EDG")) {
            this.geometryFactory = new LineGeometryFactory();
        } else if (table.equalsIgnoreCase("FAC")) {
            this.geometryFactory = new AreaGeometryFactory();
        } else if (table.equalsIgnoreCase("CND")) {
            this.geometryFactory = new ConnectedNodeGeometryFactory();
        } else if (table.equalsIgnoreCase("END")) {
            this.geometryFactory = new EntityNodeGeometryFactory();
        } else if (table.equalsIgnoreCase("TXT")) {
            this.geometryFactory = new TextGeometryFactory();
            this.textTypeFeature = true;
        }
    }

    public VPFCoverage getCoverage() {
        return this.coverage;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public synchronized List<VPFFile> getFileList() {
        ArrayList<ColumnSet> csets = new ArrayList<ColumnSet>(this.columnSet.values());
        ArrayList<VPFFile> fileList = new ArrayList<VPFFile>();
        for (int i = 0; i < csets.size(); ++i) {
            ColumnSet cs = (ColumnSet)csets.get(i);
            fileList.add(cs.table);
        }
        return fileList;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public String getTypeName() {
        return this.featureType.getTypeName();
    }

    public String getFCTypeName() {
        return this.typeName;
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public boolean isAbstract() {
        return this.featureType.isAbstract();
    }

    public VPFGeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public boolean equals(Object obj) {
        return this.featureType.equals(obj);
    }

    public int hashCode() {
        return this.featureType.hashCode();
    }

    public AttributeDescriptor getDescriptor(Name name) {
        return this.featureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(String name) {
        return this.featureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(int index) {
        return this.featureType.getDescriptor(index);
    }

    public List getAttributeDescriptors() {
        return this.featureType.getAttributeDescriptors();
    }

    public AttributeType getType(Name name) {
        return this.featureType.getType(name);
    }

    public AttributeType getType(String name) {
        return this.featureType.getType(name);
    }

    public AttributeType getType(int index) {
        return this.featureType.getType(index);
    }

    public List getTypes() {
        return this.featureType.getTypes();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.featureType.getCoordinateReferenceSystem();
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return this.featureType.getGeometryDescriptor();
    }

    public Class getBinding() {
        return this.featureType.getBinding();
    }

    public Collection getDescriptors() {
        return this.featureType.getDescriptors();
    }

    public boolean isInline() {
        return this.featureType.isInline();
    }

    public AttributeType getSuper() {
        return this.featureType.getSuper();
    }

    public boolean isIdentified() {
        return this.featureType.isIdentified();
    }

    public InternationalString getDescription() {
        return this.featureType.getDescription();
    }

    public Name getName() {
        return this.featureType.getName();
    }

    public int indexOf(String name) {
        return this.featureType.indexOf(name);
    }

    public int indexOf(Name name) {
        return this.featureType.indexOf(name);
    }

    public List<Filter> getRestrictions() {
        return this.featureType.getRestrictions();
    }

    public Map<Object, Object> getUserData() {
        return this.featureType.getUserData();
    }
}

