/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFLogger;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class VPFFeatureType
implements SimpleFeatureType {
    private final VPFFeatureClass featureClass;
    private final String typeName;
    private final String faccCode;

    public static void debugFeature(SimpleFeature feature) {
        String featureName = feature.getName() != null ? feature.getName().getLocalPart() : "";
        String id = feature.getID();
        SimpleFeatureType featureType = feature.getFeatureType();
        String featureTypeName = featureType.getTypeName();
        int attrCount = feature.getAttributeCount();
        int attrCount2 = featureType.getAttributeCount();
        VPFLogger.log("****** dbug feature: " + id);
        VPFLogger.log("          name: " + featureName);
        VPFLogger.log("      typeName: " + featureTypeName);
        VPFLogger.log("     attrCount: " + attrCount);
        VPFLogger.log("    attrCount2: " + attrCount2);
        for (int iat = 0; iat < attrCount; ++iat) {
            Object attr = feature.getAttribute(iat);
            AttributeDescriptor desc = featureType.getDescriptor(iat);
            String aname = desc != null ? desc.getLocalName() : "null";
            String avalue = attr != null ? attr.toString() : "null";
            VPFLogger.log(aname + ": " + avalue);
        }
    }

    public static void debugFeatureType(SimpleFeatureType featureType) {
        String featureTypeName = featureType.getTypeName();
        int attrCount = featureType.getAttributeCount();
        VPFLogger.log("****** dbug featureType: " + featureTypeName);
        VPFLogger.log("              attrCount: " + attrCount);
        for (int iat = 0; iat < attrCount; ++iat) {
            AttributeDescriptor desc = featureType.getDescriptor(iat);
            VPFLogger.log(desc.getLocalName());
        }
    }

    public VPFFeatureType(VPFFeatureClass cFeatureClass, SimpleFeature cFeature) {
        this.featureClass = cFeatureClass;
        this.faccCode = cFeature.getAttribute("value").toString().trim();
        String mainTableFileName = cFeature.getAttribute("table").toString().trim();
        String tempTypeName = cFeature.getAttribute("description").toString().trim();
        try {
            int index = mainTableFileName.lastIndexOf(".") + 1;
            String dimensionality = mainTableFileName.substring(index, index + 1).toLowerCase();
            if (dimensionality.equals("a")) {
                tempTypeName = tempTypeName.concat(" Area");
            } else if (dimensionality.equals("l")) {
                tempTypeName = tempTypeName.concat(" Line");
            } else if (dimensionality.equals("p")) {
                tempTypeName = tempTypeName.concat(" Point");
            } else if (dimensionality.equals("t")) {
                tempTypeName = tempTypeName.concat(" Text");
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        tempTypeName = tempTypeName.toUpperCase();
        tempTypeName = tempTypeName.replace(' ', '_');
        tempTypeName = tempTypeName.replace('/', '_');
        tempTypeName = tempTypeName.replace('(', '_');
        this.typeName = tempTypeName = tempTypeName.replace(')', '_');
    }

    public VPFFeatureType(VPFFeatureClass cFeatureClass) {
        this.featureClass = cFeatureClass;
        this.faccCode = null;
        this.typeName = cFeatureClass.getTypeName().toUpperCase();
    }

    public int getAttributeCount() {
        return this.featureClass.getAttributeCount();
    }

    public VPFCoverage getCoverage() {
        return this.featureClass.getCoverage();
    }

    public String getDirectoryName() {
        return this.featureClass.getDirectoryName();
    }

    public VPFFeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public synchronized List<SimpleFeature> readAllRows() throws IOException {
        return this.featureClass.readAllRows(this);
    }

    public List getFileList() {
        return this.featureClass.getFileList();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isAbstract() {
        return this.featureClass.isAbstract();
    }

    public String getFaccCode() {
        return this.faccCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VPFFeatureType) {
            return Objects.equals(this.featureClass, ((VPFFeatureType)obj).featureClass);
        }
        return false;
    }

    public int hashCode() {
        return this.featureClass.hashCode();
    }

    public AttributeDescriptor getDescriptor(int index) {
        return this.featureClass.getDescriptor(index);
    }

    public List getAttributeDescriptors() {
        return this.featureClass.getAttributeDescriptors();
    }

    public AttributeDescriptor getDescriptor(Name name) {
        return this.featureClass.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(String name) {
        return this.featureClass.getDescriptor(name);
    }

    public AttributeType getType(Name name) {
        return this.featureClass.getType(name);
    }

    public AttributeType getType(String name) {
        return this.featureClass.getType(name);
    }

    public AttributeType getType(int index) {
        return this.featureClass.getType(index);
    }

    public List getTypes() {
        return this.featureClass.getTypes();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.featureClass.getCoordinateReferenceSystem();
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return this.featureClass.getGeometryDescriptor();
    }

    public Class getBinding() {
        return this.featureClass.getBinding();
    }

    public Collection getDescriptors() {
        return this.featureClass.getDescriptors();
    }

    public boolean isInline() {
        return this.featureClass.isInline();
    }

    public List getRestrictions() {
        return this.featureClass.getRestrictions();
    }

    public AttributeType getSuper() {
        return this.featureClass.getSuper();
    }

    public boolean isIdentified() {
        return this.featureClass.isIdentified();
    }

    public InternationalString getDescription() {
        return this.featureClass.getDescription();
    }

    public Name getName() {
        return this.featureClass.getName();
    }

    public Map<Object, Object> getUserData() {
        return this.featureClass.getUserData();
    }

    public int indexOf(String name) {
        return this.featureClass.indexOf(name);
    }

    public int indexOf(Name name) {
        return this.featureClass.indexOf(name);
    }
}

