/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Vector;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class AreaGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    @Override
    public synchronized void createGeometry(VPFFeatureType featureType, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        Geometry result = this.buildGeometry(featureType.getFeatureClass(), values);
        values.setDefaultGeometry((Object)result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Geometry buildGeometry(VPFFeatureClass featureClass, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        boolean isLeft = false;
        Coordinate previousCoordinate = null;
        Coordinate coordinate = null;
        LinkedList<Object> coordinates = null;
        Polygon result = null;
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing outerRing = null;
        Vector<LinearRing> innerRings = new Vector<LinearRing>();
        int faceId = Integer.parseInt(values.getAttribute("fac_id").toString());
        String baseDirectory = featureClass.getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("FAC")).exists()) {
            Short tileId = Short.parseShort(values.getAttribute("tile_id").toString());
            VPFLibrary vpf = featureClass.getCoverage().getLibrary();
            String tileName = (String)vpf.getTileMap().get(tileId);
            if (tileName != null) {
                tileDirectory = tileDirectory.concat(File.separator).concat(tileName.toUpperCase()).trim();
            }
        }
        if (!new File(tileDirectory.concat(File.separator).concat("FAC")).exists()) {
            return null;
        }
        String edgeTableName = tileDirectory.concat(File.separator).concat("EDG");
        VPFFile edgeFile = VPFFileFactory.getInstance().getFile(edgeTableName);
        edgeFile.reset();
        String faceTableName = tileDirectory.concat(File.separator).concat("FAC");
        VPFFile faceFile = VPFFileFactory.getInstance().getFile(faceTableName);
        faceFile.reset();
        String ringTableName = tileDirectory.concat(File.separator).concat("RNG");
        VPFFile ringFile = VPFFileFactory.getInstance().getFile(ringTableName);
        ringFile.reset();
        SimpleFeature faceFeature = faceFile.readFeature();
        while (faceFeature != null) {
            if (faceFeature.getAttribute("id").equals(faceId)) {
                int startEdgeId;
                coordinates = new LinkedList<Object>();
                int ringId = Integer.parseInt(faceFeature.getAttribute("ring_ptr").toString());
                int nextEdgeId = startEdgeId = ((Number)ringFile.getRowFromId("id", ringId).getAttribute("start_edge")).intValue();
                int prevNodeId = -1;
                while (nextEdgeId > 0) {
                    int tempEdgeId;
                    int rightEdge;
                    int leftEdge;
                    int endNode;
                    int startNode;
                    int rightFace;
                    int leftFace;
                    SimpleFeature edgeRow = edgeFile.getRowFromId("id", nextEdgeId);
                    Object attrLeftFace = edgeRow.getAttribute("left_face");
                    boolean addPoints = true;
                    if (attrLeftFace instanceof Integer) {
                        leftFace = (Integer)edgeRow.getAttribute("left_face");
                        rightFace = (Integer)edgeRow.getAttribute("right_face");
                        startNode = (Integer)edgeRow.getAttribute("start_node");
                        endNode = (Integer)edgeRow.getAttribute("end_node");
                        leftEdge = (Integer)edgeRow.getAttribute("left_edge");
                        rightEdge = (Integer)edgeRow.getAttribute("right_edge");
                    } else {
                        leftFace = ((TripletId)edgeRow.getAttribute("left_face")).getId();
                        rightFace = ((TripletId)edgeRow.getAttribute("right_face")).getId();
                        startNode = (Integer)edgeRow.getAttribute("start_node");
                        endNode = (Integer)edgeRow.getAttribute("end_node");
                        leftEdge = ((TripletId)edgeRow.getAttribute("left_edge")).getId();
                        rightEdge = ((TripletId)edgeRow.getAttribute("right_edge")).getId();
                    }
                    if (faceId == leftFace && faceId == rightFace) {
                        addPoints = false;
                        if (prevNodeId == startNode) {
                            isLeft = false;
                            prevNodeId = endNode;
                        } else if (prevNodeId == endNode) {
                            isLeft = true;
                            prevNodeId = startNode;
                        } else {
                            if (prevNodeId != -1) throw new SQLException("This edge is not part of this face.");
                            int leftEdgeStartNode = (Integer)edgeFile.getRowFromId("id", leftEdge).getAttribute("start_node");
                            int rightEdgeStartNode = (Integer)edgeFile.getRowFromId("id", rightEdge).getAttribute("start_node");
                            if (leftEdgeStartNode == endNode) {
                                isLeft = true;
                                prevNodeId = startNode;
                            } else {
                                if (rightEdgeStartNode != endNode) throw new SQLException("This edge is not part of this face.");
                                isLeft = false;
                                prevNodeId = endNode;
                            }
                        }
                    } else if (faceId == rightFace) {
                        isLeft = false;
                        prevNodeId = endNode;
                    } else {
                        if (faceId != leftFace) throw new SQLException("This edge is not part of this face.");
                        isLeft = true;
                        prevNodeId = startNode;
                    }
                    LineString edgeGeometry = (LineString)edgeRow.getAttribute("coordinates");
                    if (addPoints) {
                        int inx;
                        if (isLeft) {
                            for (inx = edgeGeometry.getNumPoints() - 1; inx >= 0; --inx) {
                                coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(inx);
                                if (previousCoordinate != null && coordinate.equals3D(previousCoordinate)) continue;
                                coordinates.add(coordinate);
                                previousCoordinate = coordinate;
                            }
                        } else {
                            for (inx = 0; inx < edgeGeometry.getNumPoints(); ++inx) {
                                coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(inx);
                                if (previousCoordinate != null && coordinate.equals3D(previousCoordinate)) continue;
                                coordinates.add(coordinate);
                                previousCoordinate = coordinate;
                            }
                        }
                    } else {
                        coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(isLeft ? 0 : edgeGeometry.getNumPoints() - 1);
                    }
                    int n = tempEdgeId = isLeft ? leftEdge : rightEdge;
                    if (tempEdgeId == startEdgeId) {
                        nextEdgeId = 0;
                        continue;
                    }
                    nextEdgeId = tempEdgeId;
                }
                if (!coordinate.equals(coordinates.get(0))) {
                    coordinates.add(coordinates.get(0));
                }
                Coordinate[] coordinateArray = new Coordinate[coordinates.size()];
                for (int cnx = 0; cnx < coordinates.size(); ++cnx) {
                    coordinateArray[cnx] = (Coordinate)coordinates.get(cnx);
                }
                LinearRing ring = null;
                ring = geometryFactory.createLinearRing(coordinateArray);
                if (outerRing == null) {
                    outerRing = ring;
                } else {
                    innerRings.add(ring);
                }
            }
            if (faceFile.hasNext()) {
                faceFeature = faceFile.readFeature();
                continue;
            }
            faceFeature = null;
        }
        if (innerRings.isEmpty()) {
            return geometryFactory.createPolygon(outerRing, null);
        }
        LinearRing[] ringArray = new LinearRing[innerRings.size()];
        int cnx = 0;
        while (cnx < innerRings.size()) {
            ringArray[cnx] = (LinearRing)innerRings.get(cnx);
            ++cnx;
        }
        return geometryFactory.createPolygon(outerRing, ringArray);
    }
}

