/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.locationtech.jts.geom.Geometry;

public class VPFColumn {
    private boolean attemptLookup = false;
    private final AttributeDescriptor descriptor;
    private final String name;
    private final int elementsNumber;
    private final String narrTable;
    private final char keyType;
    private final String colDesc;
    private final String thematicIdx;
    private final char typeChar;
    private final String valDescTableName;

    public VPFColumn(String name, char type, int elementsNumber, char keyType, String colDesc, String valDescTableName, String thematicIdx, String narrTable) {
        this.name = name;
        this.typeChar = type;
        this.elementsNumber = elementsNumber;
        this.keyType = keyType;
        this.colDesc = colDesc;
        this.valDescTableName = valDescTableName;
        this.thematicIdx = thematicIdx;
        this.narrTable = narrTable;
        this.descriptor = new AttributeTypeBuilder().length(this.getColumnSize()).description(colDesc).binding(this.getColumnClass()).nillable(true).buildDescriptor(name);
        this.descriptor.getUserData().put("column", this);
    }

    public VPFColumn(String name, AttributeDescriptor descriptor) {
        this.name = name;
        this.descriptor = descriptor;
        this.typeChar = (char)67;
        this.elementsNumber = 0;
        this.keyType = '\u0000';
        this.colDesc = "geometry column placeholder";
        this.thematicIdx = null;
        this.narrTable = null;
        this.valDescTableName = null;
    }

    public static VPFColumn toVPFColumn(AttributeDescriptor descriptor) {
        return (VPFColumn)descriptor.getUserData().get("column");
    }

    public AttributeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class<?> getColumnClass() {
        Class columnClass;
        switch (this.typeChar) {
            case 'I': {
                columnClass = Integer.class;
                break;
            }
            case 'F': {
                columnClass = Float.class;
                break;
            }
            case 'R': {
                columnClass = Double.class;
                break;
            }
            case 'B': 
            case 'C': 
            case 'Y': 
            case 'Z': {
                columnClass = Geometry.class;
                break;
            }
            case 'K': {
                columnClass = TripletId.class;
                break;
            }
            case 'S': {
                this.attemptLookup = true;
            }
            default: {
                columnClass = String.class;
            }
        }
        return columnClass;
    }

    private int getColumnSize() {
        return DataUtils.getDataTypeSize(this.typeChar) * this.elementsNumber;
    }

    public String getNarrTable() {
        return this.narrTable;
    }

    public String getThematicIdx() {
        return this.thematicIdx;
    }

    public String getValDescTableName() {
        return this.valDescTableName;
    }

    public boolean isGeometry() {
        switch (this.typeChar) {
            case 'B': 
            case 'C': 
            case 'Y': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getElementsNumber() {
        return this.elementsNumber;
    }

    public GeometryDescriptor getGeometryAttributeType() {
        GeometryDescriptor result = null;
        if (this.isGeometry()) {
            result = (GeometryDescriptor)this.descriptor;
        }
        return result;
    }

    public boolean isAttemptLookup() {
        return this.attemptLookup;
    }

    public String getName() {
        return this.name;
    }

    public char getKeyType() {
        return this.keyType;
    }

    public String getColDesc() {
        return this.colDesc;
    }
}

