/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.data.Query;
import org.geotools.api.feature.type.Name;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.feature.NameImpl;

public abstract class VPFFeatureSource
extends ContentFeatureSource {
    private static Map<String, VPFFeatureSource> featureSourceMap = new HashMap<String, VPFFeatureSource>();

    public VPFFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
        if (entry == null) {
            VPFLogger.log("NULL ContentEntry in VPFFeatureSource");
        } else {
            String typeName = entry.getTypeName();
            if (typeName != null) {
                VPFFeatureSource.setFeatureSource(typeName, this);
            } else {
                VPFLogger.log("NULL ContentEntry typeName in VPFFeatureSource");
            }
        }
    }

    public Name getName() {
        String typeName;
        String string = typeName = this.entry != null ? this.entry.getTypeName() : null;
        if (typeName != null) {
            return new NameImpl(typeName);
        }
        return super.getName();
    }

    public static void setFeatureSource(String typeName, VPFFeatureSource featureSource) {
        featureSourceMap.put(typeName, featureSource);
    }

    public static VPFFeatureSource getFeatureSource(String typeName) {
        return featureSourceMap.get(typeName);
    }

    public ContentDataStore getDataStore() {
        return super.getDataStore();
    }
}

