/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class VPFDate {
    private SimpleDateFormat sdf = null;
    private byte[] dateBin = null;
    static final Logger LOGGER = Logging.getLogger(VPFDate.class);

    public VPFDate(byte[] date) {
        this.dateBin = (byte[])date.clone();
        this.initialize();
    }

    public VPFDate(String date) {
        this.dateBin = new byte[date.length()];
        for (int i = 0; i < date.length(); ++i) {
            this.dateBin[i] = (byte)date.charAt(i);
        }
        this.initialize();
    }

    private void initialize() {
        for (int i = 0; i < this.dateBin.length; ++i) {
            if ((char)this.dateBin[i] != ' ') continue;
            this.dateBin[i] = 48;
        }
        this.sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer sb = new StringBuffer();
        for (int i = 15; i < this.dateBin.length; ++i) {
            char cr = (char)this.dateBin[i];
            if (i == 18) {
                sb.append(':');
            }
            sb.append(cr);
        }
        this.sdf.setTimeZone(TimeZone.getTimeZone(sb.toString()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.dateBin.length);
        for (byte b : this.dateBin) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    public Date getDate() {
        try {
            return this.sdf.parse(this.toString());
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public Calendar getCalendar() {
        try {
            this.sdf.parse(this.toString());
            return this.sdf.getCalendar();
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "", e);
            return null;
        }
    }
}

