/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;
import org.geotools.api.geometry.Position;
import org.geotools.data.vpf.VPFLogger;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.ifc.VPFHeader;
import org.geotools.data.vpf.ifc.VPFRow;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.io.VariableIndexInputStream;
import org.geotools.data.vpf.io.VariableIndexRow;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.geometry.GeneralPosition;
import org.geotools.geometry.Position2D;

public abstract class VPFInputStream
implements FileConstants,
DataTypesDefinition {
    protected RandomAccessFile input = null;
    protected VPFHeader header = null;
    protected String streamFile = null;
    private List rowsReadAhead = new LinkedList();
    private VPFInputStream variableIndex = null;
    private char byteOrder = (char)76;
    private String accessMode = "r";

    public VPFInputStream(String file) throws IOException {
        this.streamFile = file;
        this.input = new RandomAccessFile(this.streamFile, this.accessMode);
        this.header = this.readHeader();
        if (this.header.getRecordSize() < 0) {
            this.variableIndex = new VariableIndexInputStream(this.getVariableIndexFileName(), this.getByteOrder());
        }
    }

    public VPFInputStream(String file, char byteOrder) throws IOException {
        this.streamFile = file;
        this.byteOrder = byteOrder;
        this.input = new RandomAccessFile(this.streamFile, this.accessMode);
        this.header = this.readHeader();
    }

    public abstract VPFHeader readHeader() throws IOException;

    public abstract VPFRow readRow() throws IOException;

    public abstract int tableSize() throws IOException;

    public String getVariableIndexFileName() {
        if (this.streamFile.equals("FCS")) {
            return "FCZ";
        }
        return this.streamFile.substring(0, this.streamFile.length() - 1) + "X";
    }

    public VPFHeader getHeader() {
        return this.header;
    }

    public char getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(char newByteOrder) {
        this.byteOrder = newByteOrder;
    }

    protected void unread(long bytes) throws IOException {
        this.input.seek(this.input.getFilePointer() - bytes);
    }

    protected void seek(long pos) throws IOException {
        this.input.seek(pos);
    }

    public void setPosition(long pos) throws IOException {
        if (this.header.getRecordSize() < 0) {
            VariableIndexRow varRow = (VariableIndexRow)this.variableIndex.readRow((int)pos);
            this.seek(varRow.getOffset());
        } else {
            this.seek((long)this.header.getLength() + (pos - 1L) * (long)this.header.getRecordSize());
        }
    }

    public VPFRow readRow(int index) throws IOException {
        this.setPosition(index);
        return this.readRow();
    }

    public List readAllRows() throws IOException {
        LinkedList<VPFRow> list = new LinkedList<VPFRow>();
        try {
            this.setPosition(1L);
        }
        catch (IOException exc) {
            return list;
        }
        VPFRow row = this.readRow();
        while (row != null) {
            list.add(row);
            row = this.readRow();
        }
        return list;
    }

    public int readRows(VPFRow[] rows) throws IOException {
        int counter = 0;
        VPFRow row = this.readRow();
        while (row != null && counter < rows.length) {
            rows[counter++] = row;
            row = this.readRow();
        }
        return counter;
    }

    public int readRows(VPFRow[] rows, int fromIndex) throws IOException {
        this.setPosition(fromIndex);
        return this.readRows(rows);
    }

    protected char readChar() throws IOException {
        return (char)this.input.read();
    }

    protected String readString(String terminators) throws IOException {
        StringBuffer text = new StringBuffer();
        char ctrl = this.readChar();
        if (terminators.indexOf(ctrl) != -1) {
            if (ctrl == ':') {
                this.unread(1L);
            }
            return null;
        }
        while (terminators.indexOf(ctrl) == -1) {
            text.append(ctrl);
            ctrl = this.readChar();
        }
        if (text.toString().equals("-")) {
            return null;
        }
        return text.toString();
    }

    protected Object readVariableSizeData(char dataType) throws IOException {
        int instances = this.readInteger();
        return this.readFixedSizeData(dataType, instances);
    }

    protected Object readFixedSizeData(char dataType, int instancesCount) throws IOException {
        Object result = null;
        switch (dataType) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                byte[] dataBytes = new byte[instancesCount * DataUtils.getDataTypeSize(dataType)];
                this.input.readFully(dataBytes);
                result = DataUtils.decodeData(dataBytes, dataType);
                break;
            }
            case 'F': {
                result = Float.valueOf(this.readFloat());
                break;
            }
            case 'R': {
                result = this.readDouble();
                break;
            }
            case 'S': {
                result = this.readShort();
                break;
            }
            case 'I': {
                result = this.readInteger();
                break;
            }
            case 'X': {
                result = "NULL";
                break;
            }
            case 'K': {
                result = this.readTripletId();
                break;
            }
            case 'C': {
                result = this.readCoord2DFloat(instancesCount);
                break;
            }
            case 'B': {
                result = this.readCoord2DDouble(instancesCount);
                break;
            }
            case 'Z': {
                result = this.readCoord3DFloat(instancesCount);
                break;
            }
            case 'Y': {
                result = this.readCoord3DDouble(instancesCount);
                break;
            }
        }
        return result;
    }

    protected byte[] readNumber(int cnt) throws IOException {
        byte[] dataBytes = new byte[cnt];
        this.input.readFully(dataBytes);
        if (this.byteOrder == 'L') {
            dataBytes = DataUtils.toBigEndian(dataBytes);
        }
        return dataBytes;
    }

    protected short readShort() throws IOException {
        return DataUtils.decodeShort(this.readNumber(2));
    }

    protected int readInteger() throws IOException {
        return DataUtils.decodeInt(this.readNumber(4));
    }

    protected float readFloat() throws IOException {
        return DataUtils.decodeFloat(this.readNumber(4));
    }

    protected double readDouble() throws IOException {
        return DataUtils.decodeDouble(this.readNumber(8));
    }

    protected TripletId readTripletId() throws IOException {
        byte tripletDef = (byte)this.input.read();
        int dataSize = TripletId.calculateDataSize(tripletDef);
        byte[] tripletData = new byte[dataSize + 1];
        tripletData[0] = tripletDef;
        if (dataSize > 0) {
            this.input.readFully(tripletData, 1, dataSize);
        }
        return new TripletId(tripletData);
    }

    protected Position[] readCoord3DFloat(int instancesCount) throws IOException {
        Position[] result = new Position[instancesCount];
        for (int inx = 0; inx < instancesCount; ++inx) {
            result[inx] = new GeneralPosition((double)this.readFloat(), (double)this.readFloat(), (double)this.readFloat());
        }
        return result;
    }

    protected Position[] readCoord2DFloat(int instancesCount) throws IOException {
        Position[] result = new Position[instancesCount];
        for (int inx = 0; inx < instancesCount; ++inx) {
            result[inx] = new Position2D((double)this.readFloat(), (double)this.readFloat());
        }
        return result;
    }

    protected Position[] readCoord2DDouble(int instancesCount) throws IOException {
        Position[] result = new Position[instancesCount];
        for (int inx = 0; inx < instancesCount; ++inx) {
            result[inx] = new Position2D(this.readDouble(), this.readDouble());
        }
        return result;
    }

    protected Position[] readCoord3DDouble(int instancesCount) throws IOException {
        Position[] result = new Position[instancesCount];
        for (int inx = 0; inx < instancesCount; ++inx) {
            result[inx] = new GeneralPosition(this.readDouble(), this.readDouble(), this.readDouble());
        }
        return result;
    }

    public int availableRows() {
        return this.rowsReadAhead != null ? this.rowsReadAhead.size() : 0;
    }

    public void close() throws IOException {
        if (this.variableIndex != null) {
            this.variableIndex.close();
            this.variableIndex = null;
        }
        this.input.close();
        this.input = null;
    }

    protected void condeb(String msg) {
        VPFLogger.log(msg);
    }
}

