/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.store.ContentState;
import org.geotools.data.vpf.file.VPFFile;

public class VPFFileFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final VPFFile file;
    private SimpleFeature currentFeature;
    protected ContentState state;

    public VPFFileFeatureReader(VPFFile file) {
        this.file = file;
        this.currentFeature = null;
        if (this.file != null) {
            this.file.reset();
        }
    }

    public VPFFileFeatureReader(ContentState contentState, VPFFile file) throws IOException {
        this.state = contentState;
        this.file = file;
        this.currentFeature = null;
        if (this.file != null) {
            this.file.reset();
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.file != null ? this.file.getFeatureType() : null;
    }

    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentFeature = this.file != null ? this.file.readFeature() : null;
        return this.currentFeature;
    }

    public boolean hasNext() throws IOException {
        boolean result = this.file != null ? this.file.hasNext() : false;
        return result;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }
}

