/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vsi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.gdal.gdal.Dataset;
import org.geotools.util.logging.Logging;
import org.geotools.vsi.VSIProperties;
import org.geotools.vsi.VSIUtils;

public class VSIDataset {
    private final Logger LOGGER = Logging.getLogger(VSIDataset.class);
    private String location;
    private File file;

    public VSIDataset(String input) {
        if (!VSIUtils.isVSILocation(input)) {
            throw new RuntimeException("could not parse invalid VSI location: " + input);
        }
        this.location = input;
        this.generate();
    }

    public static VSIDataset fromObject(Object input) {
        if (input instanceof String) {
            return new VSIDataset((String)input);
        }
        throw new RuntimeException("input object must be a String type");
    }

    public File getFile() {
        return this.file;
    }

    private File getTempFile() {
        String fileName = VSIUtils.getFileName(this.location) + ".vrt";
        String tempDir = System.getProperty("java.io.tmpdir");
        File temp = Paths.get(tempDir, fileName).toFile();
        temp.deleteOnExit();
        return temp;
    }

    public File generate() {
        try {
            new VSIProperties().apply();
        }
        catch (IOException ex) {
            this.LOGGER.fine(ex.getMessage());
        }
        File temp = this.getTempFile();
        if (temp.exists()) {
            this.LOGGER.fine(temp.getAbsolutePath() + " already exists");
        } else {
            Dataset in = null;
            try {
                in = VSIUtils.openDataset(this.location);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            this.LOGGER.fine("loaded data from " + this.location);
            Dataset out = null;
            try {
                out = VSIUtils.datasetToVRT(in, temp);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            this.LOGGER.fine("dataset exported to " + temp.getAbsolutePath());
            in.delete();
            out.delete();
        }
        this.file = temp;
        return temp;
    }
}

