/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vsi;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public final class VSIUtils {
    private static final String[] VSI_TYPES = new String[]{"zip", "gzip", "tar", "mem", "subfile", "sparse", "crypt", "curl", "curl_streaming", "s3", "s3_streaming", "gs", "gs_streaming", "az", "az_streaming", "adls", "oss", "oss_streaming", "swift", "swift_streaming", "hdfs", "webhdfs"};
    private static final String VSI_PATTERN = String.format("^(/vsi(%s)/)+[\\w\\d_\\-\\.]+/[\\w\\d_\\-\\./]+$", String.join((CharSequence)"|", Arrays.asList(VSI_TYPES)));

    public static boolean isVSILocation(String input) {
        return input == null ? false : input.matches(VSI_PATTERN);
    }

    public static String getFileName(String input) {
        if (VSIUtils.isVSILocation(input)) {
            return input.substring(input.lastIndexOf(47) + 1);
        }
        throw new IllegalArgumentException("invalid VSI Virtual File System location");
    }

    public static Dataset openDataset(String input) throws IOException {
        Dataset dataset = gdal.Open((String)input, (int)gdalconstConstants.GA_ReadOnly);
        if (dataset == null) {
            throw new IOException("GDAL could not read source path: " + input);
        }
        return dataset;
    }

    public static void addAlphaToVRT(Dataset dataset) {
        dataset.AddBand(gdalconstConstants.GDT_Byte);
        Band alpha = dataset.GetRasterBand(dataset.getRasterCount());
        alpha.SetColorInterpretation(gdalconstConstants.GCI_AlphaBand);
        String sourceData = (String)dataset.GetRasterBand(1).GetMetadata_Dict("vrt_sources").get("source_0");
        alpha.SetMetadataItem("source_0", sourceData.replaceAll("<SourceBand>[0-9]+", "<SourceBand>mask"), "new_vrt_sources");
        dataset.FlushCache();
    }

    public static Dataset datasetToVRT(Dataset source, File destination) throws IOException {
        String path = destination.getAbsolutePath();
        Driver driver = gdal.GetDriverByName((String)"VRT");
        Dataset dataset = driver.CreateCopy(path, source);
        if (dataset == null) {
            throw new IOException("GDAL could not write dataset to file: " + path);
        }
        VSIUtils.addAlphaToVRT(dataset);
        return dataset;
    }
}

