/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.vsi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.gdal.gdal.gdal;
import org.geotools.util.logging.Logging;
import org.geotools.vsi.VSIFormatFactory;

public final class VSIProperties
extends Properties {
    public static final String LOCATION_PROPERTY = "vsi.properties.location";
    private final Logger LOGGER = Logging.getLogger(VSIFormatFactory.class);

    public VSIProperties() throws IOException {
        this.parse();
    }

    public void parse() throws IOException {
        String location = System.getProperty(LOCATION_PROPERTY);
        if (location == null) {
            throw new IOException("The system property 'vsi.properties.location' is unset.");
        }
        try (FileInputStream inStream = new FileInputStream(location);){
            this.load(inStream);
        }
        catch (FileNotFoundException ex) {
            throw new FileNotFoundException("The system property 'vsi.properties.location' is set but " + location + " does not exist.");
        }
        catch (IOException ex) {
            throw new IOException("The system property 'vsi.properties.location' is set but " + location + " could not be read.");
        }
    }

    public void apply() throws IOException {
        for (String option : this.stringPropertyNames()) {
            String value = this.getProperty(option);
            gdal.SetConfigOption((String)option, (String)value);
            this.LOGGER.fine("Set GDAL config option: " + option);
        }
    }
}

