/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows10.ExceptionType;
import net.opengis.ows20.ExceptionReportType;
import org.eclipse.emf.common.util.EList;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.WFSException;
import org.geotools.data.wfs.internal.WFSRequest;
import org.geotools.data.wfs.internal.WFSResponse;
import org.geotools.data.wfs.internal.WFSResponseFactory;
import org.geotools.http.HTTPResponse;
import org.geotools.xsd.Parser;
import org.xml.sax.EntityResolver;

public abstract class AbstractWFSResponseFactory
implements WFSResponseFactory {
    private static final Logger LOGGER = Loggers.MODULE;

    @Override
    public WFSResponse createResponse(WFSRequest request, HTTPResponse response) throws IOException {
        int r;
        int buffSize = LOGGER.isLoggable(Level.FINER) ? 4096 : 512;
        PushbackInputStream pushbackIn = new PushbackInputStream(response.getResponseStream(), buffSize);
        byte[] buff = new byte[buffSize];
        int readCount = 0;
        while ((r = pushbackIn.read(buff, readCount, buffSize - readCount)) != -1 && (readCount += r) != buffSize) {
        }
        String charset = response.getResponseHeader("Charset");
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            charset = "UTF-8";
        }
        StringBuilder head = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buff), charset));){
            String line;
            while ((line = reader.readLine()) != null) {
                head.append(line).append('\n');
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Response head:\n" + String.valueOf(head));
        }
        pushbackIn.unread(buff, 0, readCount);
        if (this.isValidResponseHead(head.toString())) {
            return this.createResponseImpl(request, response, pushbackIn);
        }
        if (head.indexOf("ExceptionReport") > 0) {
            throw this.parseException(request, pushbackIn);
        }
        throw new IllegalStateException("Unkown server response: " + String.valueOf(head));
    }

    protected abstract WFSResponse createResponseImpl(WFSRequest var1, HTTPResponse var2, InputStream var3) throws IOException;

    protected abstract boolean isValidResponseHead(String var1);

    public WFSException parseException(WFSRequest originatingRequest, InputStream inputStream) throws IOException {
        Object parsed;
        Parser parser = new Parser(originatingRequest.getStrategy().getWfsConfiguration());
        EntityResolver resolver = originatingRequest.getStrategy().getConfig().getEntityResolver();
        if (resolver != null) {
            parser.setEntityResolver(resolver);
        }
        try {
            parsed = parser.parse(inputStream);
            if (!(parsed instanceof net.opengis.ows10.ExceptionReportType) && !(parsed instanceof net.opengis.ows11.ExceptionReportType)) {
                String info = String.valueOf(parsed);
                throw new IOException("Unrecognized server error: " + info);
            }
        }
        catch (Exception e) {
            return new WFSException("Exception parsing server exception report", e);
        }
        if (parsed instanceof net.opengis.ows10.ExceptionReportType) {
            net.opengis.ows10.ExceptionReportType report = (net.opengis.ows10.ExceptionReportType)parsed;
            EList exceptions = report.getException();
            StringBuilder msg = new StringBuilder("WFS returned an exception.");
            msg.append(" Originating Request: ");
            msg.append(originatingRequest.toString());
            WFSException result = new WFSException(msg.toString());
            for (ExceptionType ex : exceptions) {
                EList texts = ex.getExceptionText();
                result.addExceptionDetails(ex.getExceptionCode(), ex.getLocator(), (List<String>)texts);
            }
            return result;
        }
        if (parsed instanceof net.opengis.ows11.ExceptionReportType) {
            net.opengis.ows11.ExceptionReportType report = (net.opengis.ows11.ExceptionReportType)parsed;
            EList exceptions = report.getException();
            StringBuilder msg = new StringBuilder("WFS returned an exception.");
            msg.append(" Originating Request: ");
            msg.append(originatingRequest.toString());
            WFSException result = new WFSException(msg.toString());
            for (net.opengis.ows11.ExceptionType ex : exceptions) {
                EList texts = ex.getExceptionText();
                result.addExceptionDetails(ex.getExceptionCode(), ex.getLocator(), (List<String>)texts);
            }
            return result;
        }
        ExceptionReportType report = (ExceptionReportType)parsed;
        EList exceptions = report.getException();
        StringBuilder msg = new StringBuilder("WFS returned an exception.");
        msg.append(" Originating Request: ");
        msg.append(originatingRequest.toString());
        WFSException result = new WFSException(msg.toString());
        for (net.opengis.ows20.ExceptionType ex : exceptions) {
            EList text = ex.getExceptionText();
            result.addExceptionDetails(ex.getExceptionCode(), ex.getLocator(), (List<String>)text);
        }
        return result;
    }
}

