/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.awt.RenderingHints;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.impl.WFSDataAccessFactory;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.EntityResolver;

public class WFSConfig {
    protected String user;
    protected String pass;
    protected int timeoutMillis;
    protected PreferredHttpMethod preferredMethod = PreferredHttpMethod.AUTO;
    protected int buffer;
    protected boolean tryGZIP;
    protected boolean lenient;
    protected Integer maxFeatures;
    protected Charset defaultEncoding;
    protected String wfsStrategy;
    protected Integer filterCompliance;
    protected String namespaceOverride;
    protected String outputformatOverride;
    protected boolean useDefaultSrs;
    protected String axisOrder;
    protected String axisOrderFilter;
    protected boolean gmlCompatibleTypenames;
    protected boolean useHttpConnectionPooling;
    protected int maxConnectionPoolSize;
    protected EntityResolver entityResolver;
    private static final String NAME_SEPARATOR = ":";
    private static final String NAME_SEPARATOR_GML_COMPATIBLE = "_";

    public WFSConfig() {
        this.timeoutMillis = (Integer)WFSDataStoreFactory.TIMEOUT.getDefaultValue();
        this.buffer = (Integer)WFSDataStoreFactory.BUFFER_SIZE.getDefaultValue();
        this.tryGZIP = (Boolean)WFSDataStoreFactory.TRY_GZIP.getDefaultValue();
        this.lenient = (Boolean)WFSDataStoreFactory.LENIENT.getDefaultValue();
        String encoding = (String)WFSDataStoreFactory.ENCODING.getDefaultValue();
        this.defaultEncoding = Charset.forName(encoding);
        this.maxFeatures = (Integer)WFSDataStoreFactory.MAXFEATURES.getDefaultValue();
        this.wfsStrategy = (String)WFSDataStoreFactory.WFS_STRATEGY.getDefaultValue();
        this.filterCompliance = (Integer)WFSDataStoreFactory.FILTER_COMPLIANCE.getDefaultValue();
        this.namespaceOverride = (String)WFSDataStoreFactory.NAMESPACE.getDefaultValue();
        this.gmlCompatibleTypenames = (Boolean)WFSDataStoreFactory.GML_COMPATIBLE_TYPENAMES.getDefaultValue();
        this.entityResolver = (EntityResolver)WFSDataStoreFactory.ENTITY_RESOLVER.getDefaultValue();
        this.useHttpConnectionPooling = (Boolean)WFSDataStoreFactory.USE_HTTP_CONNECTION_POOLING.getDefaultValue();
        this.maxConnectionPoolSize = (Integer)WFSDataAccessFactory.MAX_CONNECTION_POOL_SIZE.getDefaultValue();
    }

    public static WFSConfig fromParams(Map<?, ?> params) throws IOException {
        WFSConfig config = new WFSConfig();
        Boolean preferPost = (Boolean)WFSDataStoreFactory.PROTOCOL.lookUp(params);
        config.preferredMethod = preferPost == null ? PreferredHttpMethod.AUTO : (preferPost != false ? PreferredHttpMethod.HTTP_POST : PreferredHttpMethod.HTTP_GET);
        config.user = (String)WFSDataStoreFactory.USERNAME.lookUp(params);
        config.pass = (String)WFSDataStoreFactory.PASSWORD.lookUp(params);
        config.timeoutMillis = (Integer)WFSDataStoreFactory.TIMEOUT.lookUp(params);
        config.buffer = (Integer)WFSDataStoreFactory.BUFFER_SIZE.lookUp(params);
        config.tryGZIP = (Boolean)WFSDataStoreFactory.TRY_GZIP.lookUp(params);
        config.lenient = (Boolean)WFSDataStoreFactory.LENIENT.lookUp(params);
        String encoding = (String)WFSDataStoreFactory.ENCODING.lookUp(params);
        config.defaultEncoding = Charset.forName(encoding);
        config.maxFeatures = (Integer)WFSDataStoreFactory.MAXFEATURES.lookUp(params);
        config.wfsStrategy = (String)WFSDataStoreFactory.WFS_STRATEGY.lookUp(params);
        config.filterCompliance = (Integer)WFSDataStoreFactory.FILTER_COMPLIANCE.lookUp(params);
        config.namespaceOverride = (String)WFSDataStoreFactory.NAMESPACE.lookUp(params);
        config.outputformatOverride = (String)WFSDataStoreFactory.OUTPUTFORMAT.lookUp(params);
        config.axisOrder = (String)WFSDataStoreFactory.AXIS_ORDER.lookUp(params);
        config.axisOrderFilter = (String)WFSDataStoreFactory.AXIS_ORDER_FILTER.lookUp(params) == null ? (String)WFSDataStoreFactory.AXIS_ORDER.lookUp(params) : (String)WFSDataStoreFactory.AXIS_ORDER_FILTER.lookUp(params);
        config.gmlCompatibleTypenames = WFSDataStoreFactory.GML_COMPATIBLE_TYPENAMES.lookUp(params) == null ? (Boolean)WFSDataStoreFactory.GML_COMPATIBLE_TYPENAMES.getDefaultValue() : (Boolean)WFSDataStoreFactory.GML_COMPATIBLE_TYPENAMES.lookUp(params);
        config.entityResolver = (EntityResolver)WFSDataStoreFactory.ENTITY_RESOLVER.lookUp(params);
        config.useHttpConnectionPooling = (Boolean)WFSDataStoreFactory.USE_HTTP_CONNECTION_POOLING.lookUp(params);
        config.maxConnectionPoolSize = WFSDataAccessFactory.MAX_CONNECTION_POOL_SIZE.lookUp(params);
        return config;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.pass;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public PreferredHttpMethod getPreferredMethod() {
        return this.preferredMethod;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isTryGZIP() {
        return this.tryGZIP;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public Integer getMaxFeatures() {
        return this.maxFeatures;
    }

    public Charset getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getWfsStrategy() {
        return this.wfsStrategy;
    }

    public Integer getFilterCompliance() {
        return this.filterCompliance;
    }

    public String getNamespaceOverride() {
        return this.namespaceOverride;
    }

    public String getOutputformatOverride() {
        return this.outputformatOverride;
    }

    public boolean isUseDefaultSrs() {
        return this.useDefaultSrs;
    }

    public String getAxisOrder() {
        return this.axisOrder;
    }

    public String getAxisOrderFilter() {
        return this.axisOrderFilter;
    }

    public boolean isGmlCompatibleTypenames() {
        return this.gmlCompatibleTypenames;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isUseHttpConnectionPooling() {
        return this.useHttpConnectionPooling;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public static boolean invertAxisNeeded(String axisOrder, CoordinateReferenceSystem crs) {
        CRS.AxisOrder requestedAxis = CRS.getAxisOrder((CoordinateReferenceSystem)crs);
        if (requestedAxis == CRS.AxisOrder.INAPPLICABLE) {
            boolean forcedLonLat = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
            requestedAxis = forcedLonLat ? CRS.AxisOrder.EAST_NORTH : CRS.AxisOrder.NORTH_EAST;
        }
        if ("North / East".equals(axisOrder)) {
            return requestedAxis.equals((Object)CRS.AxisOrder.EAST_NORTH);
        }
        if ("East / North".equals(axisOrder)) {
            return requestedAxis.equals((Object)CRS.AxisOrder.NORTH_EAST);
        }
        return false;
    }

    public String localTypeName(QName remoteTypeName) {
        String localTypeName = remoteTypeName.getLocalPart();
        if (!"".equals(remoteTypeName.getPrefix())) {
            localTypeName = remoteTypeName.getPrefix() + (this.gmlCompatibleTypenames ? NAME_SEPARATOR_GML_COMPATIBLE : NAME_SEPARATOR) + localTypeName;
        }
        return localTypeName;
    }

    public static enum PreferredHttpMethod {
        AUTO,
        HTTP_GET,
        HTTP_POST;

    }
}

