/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.ows.wms.request.AbstractGetMapRequest;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSEnvelope
implements Envelope {
    private String srsName;
    protected double minX;
    protected double minY;
    protected double maxX;
    protected double maxY;
    private CoordinateReferenceSystem crs;
    protected double resX;
    protected double resY;
    private Boolean forceXY = null;

    public CRSEnvelope() {
    }

    public CRSEnvelope(String epsgCode, double minX, double minY, double maxX, double maxY) {
        this.srsName = epsgCode;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public CRSEnvelope(Envelope envelope) {
        this.srsName = CRS.toSRS((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
        this.minX = envelope.getMinimum(0);
        this.maxX = envelope.getMaximum(0);
        this.minY = envelope.getMinimum(1);
        this.maxY = envelope.getMaximum(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CRSEnvelope cRSEnvelope = this;
        synchronized (cRSEnvelope) {
            if (this.crs == null) {
                try {
                    String srs;
                    String string = srs = this.srsName != null ? this.srsName : "CRS:84";
                    this.crs = this.forceXY == null ? CRS.decode((String)srs) : AbstractGetMapRequest.toServerCRS(this.srsName, this.forceXY);
                }
                catch (FactoryException e) {
                    this.crs = DefaultEngineeringCRS.CARTESIAN_2D;
                }
            }
            return this.crs == DefaultEngineeringCRS.CARTESIAN_2D ? null : this.crs;
        }
    }

    public String getSRSName() {
        return this.srsName;
    }

    public void setEPSGCode(String epsgCode) {
        this.setSRSName(epsgCode);
    }

    public String getEPSGCode() {
        return this.srsName;
    }

    private void setSRSName(String srsName) {
        this.srsName = srsName;
        this.forceXY = null;
    }

    public void setSRSName(String srsName, boolean forceXY) {
        this.srsName = srsName;
        this.forceXY = forceXY;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        if (dimension == 0) {
            return this.getMinX();
        }
        return this.getMinY();
    }

    public double getMaximum(int dimension) {
        if (dimension == 0) {
            return this.getMaxX();
        }
        return this.getMaxY();
    }

    public double getCenter(int dimension) {
        return this.getMedian(dimension);
    }

    public double getMedian(int dimension) {
        double min = dimension == 0 ? this.getMinX() : this.getMinY();
        return min + this.getLength(dimension) / 2.0;
    }

    public double getLength(int dimension) {
        return this.getSpan(dimension);
    }

    public double getSpan(int dimension) {
        double max;
        double min;
        if (dimension == 0) {
            min = this.getMinX();
            max = this.getMaxX();
        } else {
            min = this.getMinY();
            max = this.getMaxY();
        }
        return max - min;
    }

    public DirectPosition getUpperCorner() {
        return new GeneralDirectPosition(this.getMaxX(), this.getMaxY());
    }

    public DirectPosition getLowerCorner() {
        return new GeneralDirectPosition(this.getMinX(), this.getMinY());
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getResX() {
        return this.resX;
    }

    public void setResX(double resX) {
        this.resX = resX;
    }

    public double getResY() {
        return this.resY;
    }

    public void setResY(double resY) {
        this.resY = resY;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        build.append("[");
        build.append(this.minX);
        build.append(",");
        build.append(this.maxX);
        if (!Double.isNaN(this.resX)) {
            build.append(",");
            build.append(this.resX);
        }
        build.append(" ");
        build.append(this.minY);
        build.append(",");
        build.append(this.maxY);
        if (!Double.isNaN(this.resY)) {
            build.append(",");
            build.append(this.resY);
        }
        if (this.srsName != null) {
            build.append(" crs=");
            build.append(this.srsName);
        } else {
            build.append(" default=CRS:84");
        }
        build.append("]");
        return build.toString();
    }
}

