/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.OperationType;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.request.GetFeatureInfoRequest;
import org.geotools.ows.wms.response.GetFeatureInfoResponse;
import org.geotools.ows.wmts.WMTSSpecification;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.ows.wmts.response.GetTileResponse;
import org.geotools.referencing.CRS;
import org.geotools.tile.Tile;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WebMapTileServer
extends AbstractOpenWebService<WMTSCapabilities, Layer> {
    private WMTSServiceType type;

    public WebMapTileServer(URL serverURL, HTTPClient httpClient) throws ServiceException, IOException {
        super(serverURL, httpClient);
        this.setupType();
    }

    public WebMapTileServer(URL serverURL, HTTPClient httpClient, Map<String, String> headers) throws ServiceException, IOException {
        super(serverURL, httpClient, null, null, headers);
        this.setupType();
    }

    public WebMapTileServer(URL serverURL, WMTSCapabilities capabilities) throws ServiceException, IOException {
        this(serverURL, HTTPClientFinder.createClient(), capabilities, null);
    }

    public WebMapTileServer(URL serverURL, HTTPClient httpClient, WMTSCapabilities capabilities) throws ServiceException, IOException {
        this(serverURL, httpClient, capabilities, null);
    }

    public WebMapTileServer(URL serverURL, HTTPClient httpClient, WMTSCapabilities capabilities, Map<String, Object> hints) throws ServiceException, IOException {
        super(serverURL, httpClient, (Capabilities)capabilities, hints);
        this.setupType();
    }

    public WebMapTileServer(URL serverURL) throws IOException, ServiceException {
        super(serverURL);
        this.setupType();
    }

    public WebMapTileServer(WebMapTileServer delegate) throws ServiceException, IOException {
        this(delegate.serverURL, delegate.getHTTPClient(), (WMTSCapabilities)delegate.capabilities, delegate.hints);
    }

    public WMTSCapabilities getCapabilities() {
        return (WMTSCapabilities)this.capabilities;
    }

    protected ServiceInfo createInfo() {
        return null;
    }

    protected ResourceInfo createInfo(Layer resource) {
        return null;
    }

    protected void setupSpecifications() {
        this.specs = new WMTSSpecification[1];
        this.specs[0] = new WMTSSpecification();
    }

    WMTSSpecification getSpecification() {
        return (WMTSSpecification)this.specification;
    }

    @Deprecated
    public Set<Tile> issueRequest(GetTileRequest tileRequest) throws ServiceException {
        return tileRequest.getTiles();
    }

    public GetTileResponse issueRequest(WMTSSpecification.GetSingleTileRequest tileRequest) throws IOException, ServiceException {
        return (GetTileResponse)this.internalIssueRequest(tileRequest);
    }

    public GetTileRequest createGetTileRequest() {
        OperationType getTile = this.getCapabilities().getRequest().getGetTile();
        URL url = this.findGetTileURL(getTile);
        if (url == null) {
            this.type = WMTSServiceType.REST;
            url = this.getCapabilities().getService().getOnlineResource();
        }
        Properties props = new Properties();
        props.put("type", this.type.name());
        WMTSSpecification.GetMultiTileRequest request = this.getSpecification().createGetMultiTileRequest(url, props, this.getCapabilities(), this.getHTTPClient());
        if (this.headers != null) {
            request.getHeaders().putAll(this.headers);
        }
        return request;
    }

    public GetTileRequest createGetTileRequest(boolean multiTile) {
        WMTSSpecification.GetSingleTileRequest request;
        if (multiTile) {
            return this.createGetTileRequest();
        }
        OperationType getTile = this.getCapabilities().getRequest().getGetTile();
        URL url = this.findGetTileURL(getTile);
        Properties props = new Properties();
        props.put("type", this.type.name());
        switch (this.type) {
            case KVP: {
                request = new WMTSSpecification.GetKVPTileRequest(url, props, this.getHTTPClient());
                break;
            }
            case REST: {
                request = new WMTSSpecification.GetRestTileRequest(url, props, this.getHTTPClient());
                break;
            }
            default: {
                throw new RuntimeException("Unknown type");
            }
        }
        if (this.headers != null) {
            request.getHeaders().putAll(this.headers);
        }
        return request;
    }

    private URL findGetTileURL(OperationType operation) {
        switch (this.type) {
            case KVP: {
                if (operation == null) {
                    return null;
                }
                return operation.getGet() != null ? operation.getGet() : this.serverURL;
            }
            case REST: {
                return this.serverURL;
            }
        }
        return null;
    }

    public TileMatrixSet selectMatrixSet(WMTSLayer layer, CoordinateReferenceSystem requestCRS) throws ServiceException {
        TileMatrixSet retMatrixSet = null;
        Map<String, TileMatrixSetLink> links = layer.getTileMatrixLinks();
        if (requestCRS == null) {
            throw new IllegalArgumentException("requestCRS cannot be null");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("request CRS " + String.valueOf(requestCRS.getName()));
        }
        String requestSRS = CRS.toSRS((CoordinateReferenceSystem)requestCRS);
        for (TileMatrixSet matrixSet : ((WMTSCapabilities)this.capabilities).getMatrixSets()) {
            CoordinateReferenceSystem matrixCRS = matrixSet.getCoordinateReferenceSystem();
            String matrixSRS = CRS.toSRS((CoordinateReferenceSystem)matrixCRS);
            if (!requestSRS.equals(matrixSRS) || !links.containsKey(matrixSet.getIdentifier())) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("selected matrix set:" + matrixSet.getIdentifier());
            }
            retMatrixSet = matrixSet;
            break;
        }
        if (retMatrixSet == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Failed to match the requested CRS (" + String.valueOf(requestCRS.getName()) + ") with any of the tile matrices!");
            }
            for (TileMatrixSet matrix : ((WMTSCapabilities)this.capabilities).getMatrixSets()) {
                if (!links.containsKey(matrix.getIdentifier())) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("defaulting matrix set:" + matrix.getIdentifier());
                }
                retMatrixSet = matrix;
                break;
            }
        }
        if (retMatrixSet == null) {
            throw new ServiceException("Unable to find a matching TileMatrixSet for layer " + layer.getName() + " and SRS: " + String.valueOf(requestCRS.getName()));
        }
        return retMatrixSet;
    }

    public GetFeatureInfoRequest createGetFeatureInfoRequest(GetTileRequest getmap) {
        return null;
    }

    public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest request) {
        return null;
    }

    private void setupType() {
        this.type = this.getCapabilities().getType();
    }

    public void setType(WMTSServiceType type) {
        this.type = type;
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public GeneralEnvelope getEnvelope(Layer layer, CoordinateReferenceSystem crs) {
        Map boundingBoxes = layer.getBoundingBoxes();
        CRSEnvelope box = (CRSEnvelope)boundingBoxes.get(crs.getName().getCode());
        if (box != null) {
            return new GeneralEnvelope((Envelope)box);
        }
        for (String key : boundingBoxes.keySet()) {
            box = (CRSEnvelope)boundingBoxes.get(key);
            if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)box.getCoordinateReferenceSystem())) continue;
            return new GeneralEnvelope((Envelope)box);
        }
        return null;
    }
}

