/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.model;

import java.util.ArrayList;
import java.util.List;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wmts.model.TileMatrix;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TileMatrixSet {
    private static final CoordinateReferenceSystem WEB_MERCATOR_CRS;
    private String identifier;
    private String crs;
    private String wellKnownScaleSet;
    private CoordinateReferenceSystem coordinateReferenceSystem;
    private CRSEnvelope bbox;
    private List<TileMatrix> matrices = new ArrayList<TileMatrix>();

    public void setIdentifier(String id) {
        this.identifier = id;
    }

    public void setCRS(String crs) throws IllegalArgumentException {
        try {
            this.setCoordinateReferenceSystem(this.parseCoordinateReferenceSystem(crs));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't parse crs " + crs + ":" + ex.getMessage(), ex);
        }
        this.crs = crs;
    }

    public void addMatrix(TileMatrix tileMatrix) {
        this.matrices.add(tileMatrix);
    }

    public String getCrs() {
        return this.crs;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    protected CoordinateReferenceSystem parseCoordinateReferenceSystem(String crs) throws NoSuchAuthorityCodeException, FactoryException {
        if (crs.equalsIgnoreCase("epsg:900913") || crs.equalsIgnoreCase("urn:ogc:def:crs:EPSG::900913") || crs.equalsIgnoreCase("urn:ogc:def:crs:EPSG:6.18:3:3857")) {
            return WEB_MERCATOR_CRS;
        }
        return CRS.decode((String)crs);
    }

    public List<TileMatrix> getMatrices() {
        return this.matrices;
    }

    public void setMatrices(List<TileMatrix> matrices) {
        this.matrices = matrices;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public CRSEnvelope getBbox() {
        return this.bbox;
    }

    public void setBbox(CRSEnvelope bbox) {
        this.bbox = bbox;
    }

    public String getWellKnownScaleSet() {
        return this.wellKnownScaleSet;
    }

    public void setWellKnownScaleSet(String wellKnownScaleSet) {
        this.wellKnownScaleSet = wellKnownScaleSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getIdentifier()).append("\t").append(this.getCrs()).append("\n");
        for (TileMatrix m : this.matrices) {
            sb.append("\t").append(m.toString());
        }
        return sb.toString();
    }

    public int size() {
        return this.matrices.size();
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    static {
        CoordinateReferenceSystem tmpCrs = null;
        try {
            tmpCrs = CRS.decode((String)"EPSG:3857");
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        WEB_MERCATOR_CRS = tmpCrs;
    }
}

