/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMTSLayer
extends Layer {
    public static final Logger LOGGER = Logging.getLogger(WMTSLayer.class);
    Map<String, TileMatrixSetLink> limits = new HashMap<String, TileMatrixSetLink>();
    List<String> formats = new ArrayList<String>();
    List<String> infoFormats = new ArrayList<String>();
    Map<String, String> templates = new HashMap<String, String>();
    private CoordinateReferenceSystem preferredCRS = null;
    private StyleImpl defaultStyle;

    public WMTSLayer(String title) {
        super(title);
    }

    public Map<String, TileMatrixSetLink> getTileMatrixLinks() {
        return this.limits;
    }

    public void addTileMatrixLinks(List<TileMatrixSetLink> limitList) {
        for (TileMatrixSetLink limit : limitList) {
            this.limits.put(limit.getIdentifier(), limit);
        }
    }

    public void addTileMatrixLink(TileMatrixSetLink link) {
        this.limits.put(link.getIdentifier(), link);
    }

    public List<String> getFormats() {
        return this.formats;
    }

    public void setFormats(List<String> formats) {
        this.formats = formats;
    }

    public List<String> getInfoFormats() {
        return this.infoFormats;
    }

    public void setInfoFormats(List<String> infoFormats) {
        this.infoFormats = infoFormats;
    }

    public void putResourceURL(String format, String template) {
        this.templates.put(format, template);
    }

    public String getTemplate(String key) {
        return this.templates.get(key);
    }

    public void addSRS(CoordinateReferenceSystem crs) {
        if (this.srs == null) {
            this.srs = new HashSet();
        }
        this.srs.add(CRS.toSRS((CoordinateReferenceSystem)crs));
    }

    public CoordinateReferenceSystem getPreferredCRS() {
        return this.preferredCRS;
    }

    public void setPreferredCRS(CoordinateReferenceSystem preferredCRS) {
        this.preferredCRS = preferredCRS;
    }

    public void setDefaultStyle(StyleImpl style) {
        this.defaultStyle = style;
    }

    public StyleImpl getDefaultStyle() {
        return this.defaultStyle;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    protected Collection<String> extractCRSNames(CoordinateReferenceSystem crs) {
        return Arrays.asList(CRS.toSRS((CoordinateReferenceSystem)crs));
    }
}

