/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.map;

import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.GridReaderLayer;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSCoverageReader;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WMTSMapLayer
extends GridReaderLayer {
    public static final Logger LOGGER = Logging.getLogger(WMTSMapLayer.class);
    private String rawTime;

    private static Style createStyle() {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer symbolizer = factory.createRasterSymbolizer();
        Rule rule = factory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle type = factory.createFeatureTypeStyle();
        type.rules().add(rule);
        Style style = factory.createStyle();
        style.featureTypeStyles().add(type);
        return style;
    }

    public WMTSMapLayer(WebMapTileServer wmts, Layer layer) {
        super((GridCoverage2DReader)new WMTSCoverageReader(wmts, layer), WMTSMapLayer.createStyle());
    }

    public WMTSCoverageReader getReader() {
        return (WMTSCoverageReader)this.reader;
    }

    public synchronized ReferencedEnvelope getBounds() {
        WMTSCoverageReader wmtsReader = this.getReader();
        if (wmtsReader != null) {
            return wmtsReader.bounds;
        }
        return super.getBounds();
    }

    public WebMapTileServer getWebMapServer() {
        return this.getReader().wmts;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.reader.getCoordinateReferenceSystem();
    }

    public GetTileRequest getLastGetMap() {
        return this.getReader().getTileRequest();
    }

    public boolean isNativelySupported(CoordinateReferenceSystem crs) {
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            return code != null && this.getReader().validSRS.contains(code);
        }
        catch (Exception t) {
            return false;
        }
    }

    public String getRawTime() {
        return this.rawTime;
    }

    public void setRawTime(String rawTime) {
        this.rawTime = rawTime;
        this.getReader().setRequestedTime(rawTime);
    }
}

