/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.xml.styling.SLDParser;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.encode.YsldEncoder;
import org.geotools.ysld.parse.YsldParser;
import org.geotools.ysld.parse.ZoomContextFinder;
import org.geotools.ysld.validate.YsldValidator;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class Ysld {
    public static String OPTION_PREFIX = "x-";

    static YsldInput reader(Object input) throws IOException {
        if (input instanceof Reader) {
            return new YsldInput((Reader)input);
        }
        if (input instanceof InputStream) {
            return new YsldInput(new BufferedReader(new InputStreamReader((InputStream)input)));
        }
        if (input instanceof File) {
            return new YsldInput(new BufferedReader(new FileReader((File)input)));
        }
        if (input instanceof String) {
            return new YsldInput(new StringReader((String)input));
        }
        throw new IllegalArgumentException("Unable to turn " + input + " into reader");
    }

    static Writer writer(Object output) throws IOException {
        if (output instanceof Writer) {
            return (Writer)output;
        }
        if (output instanceof OutputStream) {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)output));
        }
        if (output instanceof File) {
            return new BufferedWriter(new FileWriter((File)output));
        }
        throw new IllegalArgumentException("Unable to turn " + output + " into writer");
    }

    public static XMLStreamReader xmlReader(Object input) throws IOException {
        try (YsldInput in = Ysld.reader(input);){
            XMLInputFactory xmlFactory = XMLInputFactory.newFactory();
            try {
                XMLStreamReader xMLStreamReader = xmlFactory.createXMLStreamReader(in.reader);
                return xMLStreamReader;
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }

    public static StyledLayerDescriptor parse(Object ysld, @Nullable List<ZoomContextFinder> zCtxtFinders, @Nullable ResourceLocator locator) throws IOException {
        return Ysld.parse(ysld, zCtxtFinders, locator, new UomMapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyledLayerDescriptor parse(Object ysld, @Nullable List<ZoomContextFinder> zCtxtFinders, @Nullable ResourceLocator locator, @Nullable UomMapper uomMapper) throws IOException {
        try (YsldInput in = Ysld.reader(ysld);){
            YsldParser parser = new YsldParser(in.reader);
            if (zCtxtFinders != null) {
                parser.setZoomContextFinders(zCtxtFinders);
            }
            if (locator != null) {
                parser.setResourceLocator(locator);
            }
            if (uomMapper != null) {
                parser.setUomMapper(uomMapper);
            }
            StyledLayerDescriptor styledLayerDescriptor = parser.parse();
            return styledLayerDescriptor;
        }
    }

    public static StyledLayerDescriptor parse(Object ysld) throws IOException {
        return Ysld.parse(ysld, null, null, new UomMapper());
    }

    public static void encode(StyledLayerDescriptor sld, Object output) throws IOException {
        Ysld.encode(sld, output, new UomMapper());
    }

    public static void encode(StyledLayerDescriptor sld, Object output, UomMapper uomMapper) throws IOException {
        YsldEncoder e = new YsldEncoder(Ysld.writer(output), uomMapper);
        e.encode(sld);
    }

    public static void transform(XMLStreamReader sld, Writer ysld) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static void transform(InputStream sld, Writer ysld) throws IOException {
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory(), sld);
        StyledLayerDescriptor style = parser.parseSLD();
        Ysld.encode(style, ysld);
    }

    public static List<MarkedYAMLException> validate(Object ysld) throws IOException {
        return Ysld.validate(ysld, Collections.emptyList(), new UomMapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MarkedYAMLException> validate(Object ysld, List<ZoomContextFinder> zContextFinders, UomMapper uomMapper) throws IOException {
        try (YsldInput in = Ysld.reader(ysld);){
            YsldValidator validator = new YsldValidator();
            validator.setZCtxtFinders(zContextFinders);
            List<MarkedYAMLException> list = validator.validate(in.reader);
            return list;
        }
    }

    static class YsldInput {
        Reader reader;

        YsldInput(Reader reader) {
            this.reader = reader;
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

