/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlUtil;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YamlParseHandler;
import org.yaml.snakeyaml.reader.UnicodeReader;

public class YamlParser {
    Reader yaml;

    public YamlParser(InputStream yaml) {
        this((Reader)new UnicodeReader(yaml));
    }

    public YamlParser(Reader yaml) {
        this.yaml = yaml;
    }

    public <T extends YamlParseHandler> T parse(T root) throws IOException {
        return this.parse(root, Collections.emptyMap());
    }

    public <T extends YamlParseHandler> T parse(T root, Map<String, Object> hints) throws IOException {
        Object parsed = YamlUtil.getSafeYaml().load(this.yaml);
        YamlParseContext context = new YamlParseContext();
        context.mergeDocHints(hints);
        context.push(YamlObject.create(parsed), root);
        while (context.next()) {
        }
        return root;
    }
}

