/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.RecodeFunction;
import org.geotools.filter.function.string.ConcatenateFunction;
import org.geotools.process.function.ProcessFunction;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.ResourceLocator;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.geotools.ysld.TestUtils;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.YsldTests;
import org.geotools.ysld.parse.ScaleRange;
import org.geotools.ysld.parse.WellKnownZoomContextFinder;
import org.geotools.ysld.parse.ZoomContext;
import org.geotools.ysld.parse.ZoomContextFinder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.ContrastMethod;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.LinePlacement;
import org.opengis.style.Mark;
import org.opengis.style.PointPlacement;
import org.opengis.style.SelectedChannelType;
import org.yaml.snakeyaml.composer.ComposerException;

public class YsldParseTest {
    Logger LOG = Logging.getLogger((String)"org.geotools.ysld.Ysld");
    static final String GOOGLE_MERCATOR_TEST_RULES = "  - zoom: " + YsldParseTest.tuple(0, 0) + "\n  - zoom: " + YsldParseTest.tuple(1, 1) + "\n  - zoom: " + YsldParseTest.tuple(2, 2) + "\n  - zoom: " + YsldParseTest.tuple(3, 3) + "\n  - zoom: " + YsldParseTest.tuple(4, 4) + "\n  - zoom: " + YsldParseTest.tuple(5, 5) + "\n  - zoom: " + YsldParseTest.tuple(6, 6) + "\n  - zoom: " + YsldParseTest.tuple(7, 7) + "\n  - zoom: " + YsldParseTest.tuple(8, 8) + "\n  - zoom: " + YsldParseTest.tuple(9, 9) + "\n  - zoom: " + YsldParseTest.tuple(10, 10) + "\n  - zoom: " + YsldParseTest.tuple(11, 11) + "\n  - zoom: " + YsldParseTest.tuple(12, 12) + "\n  - zoom: " + YsldParseTest.tuple(13, 13) + "\n  - zoom: " + YsldParseTest.tuple(14, 14) + "\n  - zoom: " + YsldParseTest.tuple(15, 15) + "\n  - zoom: " + YsldParseTest.tuple(16, 16) + "\n  - zoom: " + YsldParseTest.tuple(17, 17) + "\n  - zoom: " + YsldParseTest.tuple(18, 18) + "\n  - zoom: " + YsldParseTest.tuple(19, 19) + "\n";
    static final String WGS84_TEST_RULES = "  - zoom: " + YsldParseTest.tuple(0, 0) + "\n    name: WGS84:00\n  - zoom: " + YsldParseTest.tuple(1, 1) + "\n    name: WGS84:01\n  - zoom: " + YsldParseTest.tuple(2, 2) + "\n    name: WGS84:02\n  - zoom: " + YsldParseTest.tuple(3, 3) + "\n    name: WGS84:03\n  - zoom: " + YsldParseTest.tuple(4, 4) + "\n    name: WGS84:04\n  - zoom: " + YsldParseTest.tuple(5, 5) + "\n    name: WGS84:05\n  - zoom: " + YsldParseTest.tuple(6, 6) + "\n    name: WGS84:06\n  - zoom: " + YsldParseTest.tuple(7, 7) + "\n    name: WGS84:07\n  - zoom: " + YsldParseTest.tuple(8, 8) + "\n    name: WGS84:08\n  - zoom: " + YsldParseTest.tuple(9, 9) + "\n    name: WGS84:09\n  - zoom: " + YsldParseTest.tuple(10, 10) + "\n    name: WGS84:10\n  - zoom: " + YsldParseTest.tuple(11, 11) + "\n    name: WGS84:11\n  - zoom: " + YsldParseTest.tuple(12, 12) + "\n    name: WGS84:12\n  - zoom: " + YsldParseTest.tuple(13, 13) + "\n    name: WGS84:13\n  - zoom: " + YsldParseTest.tuple(14, 14) + "\n    name: WGS84:14\n  - zoom: " + YsldParseTest.tuple(15, 15) + "\n    name: WGS84:15\n  - zoom: " + YsldParseTest.tuple(16, 16) + "\n    name: WGS84:16\n  - zoom: " + YsldParseTest.tuple(17, 17) + "\n    name: WGS84:17\n  - zoom: " + YsldParseTest.tuple(18, 18) + "\n    name: WGS84:18\n  - zoom: " + YsldParseTest.tuple(19, 19) + "\n    name: WGS84:19\n  - zoom: " + YsldParseTest.tuple(20, 20) + "\n    name: WGS84:20\n";
    double[] GOOGLE_MERCATOR_PIXEL_SIZES = new double[]{156543.033928041, 78271.51696402048, 39135.75848201023, 19567.87924100512, 9783.93962050256, 4891.96981025128, 2445.98490512564, 1222.99245256282, 611.49622628141, 305.7481131407048, 152.8740565703525, 76.43702828517624, 38.21851414258813, 19.10925707129406, 9.554628535647032, 4.777314267823516, 2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.29858214173896974, 0.14929107086948487};
    double INCHES_PER_METRE = 39.3701;
    double OGC_DPI = 90.0;
    final double[] WGS84_SCALE_DENOMS = new double[]{5.590822639508929E8, 2.795411320143589E8, 1.3977056600717944E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.1877243575, 2183915.0938621787, 1091957.5469310894, 545978.7734655447, 272989.38673277234, 136494.69336638617, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784, 1066.364791924892, 533.182395962446};

    @Test
    public void testRoot() throws Exception {
        StyledLayerDescriptor sld = Ysld.parse((Object)"layer-name: MyLayer\nname: MyStyle");
        NamedLayer namedLayer = (NamedLayer)sld.layers().get(0);
        Assert.assertEquals((Object)"MyLayer", (Object)namedLayer.getName());
        Assert.assertEquals((Object)"MyStyle", (Object)((Style)namedLayer.styles().get(0)).getName());
        sld = Ysld.parse((Object)"sld-name: SLDName\nsld-title: SLD Title\nsld-abstract: Remote user layer\nuser-name: RemoteLayer\nuser-remote: http://localhost:8080/geoserver/wms\nuser-service: wms\nname: RemoteStyle");
        Assert.assertEquals((Object)"SLDName", (Object)sld.getName());
        Assert.assertEquals((Object)"SLD Title", (Object)sld.getTitle());
        Assert.assertEquals((Object)"Remote user layer", (Object)sld.getAbstract());
        UserLayer userlayer = (UserLayer)sld.layers().get(0);
        Assert.assertEquals((Object)"RemoteLayer", (Object)userlayer.getName());
        Assert.assertEquals((Object)"wms", (Object)userlayer.getRemoteOWS().getService());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/wms", (Object)userlayer.getRemoteOWS().getOnlineResource());
        Assert.assertEquals((Object)"RemoteStyle", (Object)((Style)userlayer.userStyles().get(0)).getName());
    }

    @Test
    public void testAnchor() throws Exception {
        String yaml = "blue: &blue rgb(0,0,255)\npoint: \n  symbols: \n  - mark: \n      fill-color: *blue\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Assert.assertEquals((Object)Color.BLUE, (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)p)));
    }

    @Test
    public void testNamedColor() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: blue\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Assert.assertEquals((Object)Color.BLUE, (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)p)));
    }

    @Test
    public void testFilterFunctionNoMarker() throws Exception {
        String yaml = "rules: \n- filter: strEndsWith(foo,'bar') = true\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule r = (Rule)((FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0)).rules().get(0);
        PropertyIsEqualTo f = (PropertyIsEqualTo)r.getFilter();
        Function func = (Function)f.getExpression1();
        Assert.assertEquals((Object)"strEndsWith", (Object)func.getName());
        Assert.assertTrue((boolean)(func.getParameters().get(0) instanceof PropertyName));
        Assert.assertTrue((boolean)(func.getParameters().get(1) instanceof Literal));
        MatcherAssert.assertThat((Object)f.getExpression2(), (Matcher)CoreMatchers.instanceOf(Literal.class));
    }

    @Test
    public void testFilterFunctionWithMarker() throws Exception {
        String yaml = "rules: \n- filter: ${strEndsWith(foo,'bar') = true}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule r = (Rule)((FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0)).rules().get(0);
        PropertyIsEqualTo f = (PropertyIsEqualTo)r.getFilter();
        Function func = (Function)f.getExpression1();
        Assert.assertEquals((Object)"strEndsWith", (Object)func.getName());
        Assert.assertTrue((boolean)(func.getParameters().get(0) instanceof PropertyName));
        Assert.assertTrue((boolean)(func.getParameters().get(1) instanceof Literal));
        MatcherAssert.assertThat((Object)f.getExpression2(), (Matcher)CoreMatchers.instanceOf(Literal.class));
    }

    @Test
    public void testFilterFunctionWithMarker2() throws Exception {
        String yaml = "rules: \n- filter: ${scalerank < 4}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule r = (Rule)((FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0)).rules().get(0);
        Filter f = r.getFilter();
        MatcherAssert.assertThat((Object)f, (Matcher)Matchers.instanceOf(PropertyIsLessThan.class));
        MatcherAssert.assertThat((Object)((PropertyIsLessThan)f).getExpression1(), TestUtils.attribute("scalerank"));
        MatcherAssert.assertThat((Object)((PropertyIsLessThan)f).getExpression2(), TestUtils.literal(4));
    }

    @Test
    public void testFilterWithEscape() throws Exception {
        String yaml = "rules: \n- filter: ${foo = '\\$\\}'}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule r = (Rule)((FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0)).rules().get(0);
        Filter f = r.getFilter();
        MatcherAssert.assertThat((Object)f, (Matcher)Matchers.instanceOf(PropertyIsEqualTo.class));
        MatcherAssert.assertThat((Object)((PropertyIsEqualTo)f).getExpression1(), TestUtils.attribute("foo"));
        MatcherAssert.assertThat((Object)((PropertyIsEqualTo)f).getExpression2(), TestUtils.literal("$}"));
    }

    @Test
    public void testRenderingTransformation() throws IOException {
        String yaml = "feature-styles: \n- transform:\n    name: ras:Contour\n    params:\n      levels:\n      - 1000\n      - 1100\n      - 1200\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("data", new Matcher[0]), this.rtParam("levels", TestUtils.literal(1000), TestUtils.literal(1100), TestUtils.literal(1200))})));
    }

    Matcher<Function> rtParam(final String name, final Matcher<?> ... values) {
        return new BaseMatcher(){

            public boolean matches(Object item) {
                Function f = (Function)item;
                List parameters = f.getParameters();
                Literal nameExpr = (Literal)parameters.get(0);
                if (!nameExpr.getValue().equals(name)) {
                    return false;
                }
                if (values.length != parameters.size() - 1) {
                    return false;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (values[i].matches(parameters.get(i + 1))) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Parameter named ");
                description.appendValue((Object)name);
                if (values.length == 0) {
                    description.appendText(" with no values");
                } else if (values.length == 1) {
                    description.appendText(" with value ");
                    description.appendDescriptionOf((SelfDescribing)values[0]);
                } else {
                    description.appendText(" with values ").appendList("[", ", ", "]", Arrays.asList(values));
                }
            }
        };
    }

    @Test
    public void testRenderingTransformationHeatmap() throws IOException {
        String yaml = "feature-styles: \n- transform:\n    name: vec:Heatmap\n    params:\n      weightAttr: pop2000\n      radius: 100\n      pixelsPerCell: 10\n      outputBBOX: ${env('wms_bbox')}\n      outputWidth: ${env('wms_width')}\n      outputHeight: ${env('wms_height')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("data", new Matcher[0]), this.rtParam("weightAttr", TestUtils.literal("pop2000")), this.rtParam("radius", TestUtils.literal(100)), this.rtParam("pixelsPerCell", TestUtils.literal(10)), this.rtParam("outputBBOX", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_bbox")})), this.rtParam("outputWidth", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_width")})), this.rtParam("outputHeight", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_height")}))})));
    }

    @Test
    public void testRenderingTransformationAlternateInputParam() throws IOException {
        String yaml = "feature-styles: \n- transform:\n    input: foo\n    name: ras:Contour\n    params:\n      levels:\n      - 1000\n      - 1100\n      - 1200\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("foo", new Matcher[0]), this.rtParam("levels", TestUtils.literal(1000), TestUtils.literal(1100), TestUtils.literal(1200))})));
    }

    @Test
    public void testRenderingTransformationWMSAuto() throws IOException {
        String yaml = "feature-styles: \n- transform:\n    name: vec:Heatmap\n    params:\n      weightAttr: pop2000\n      radius: 100\n      pixelsPerCell: 10\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("data", new Matcher[0]), this.rtParam("weightAttr", TestUtils.literal("pop2000")), this.rtParam("radius", TestUtils.literal(100)), this.rtParam("pixelsPerCell", TestUtils.literal(10)), this.rtParam("outputBBOX", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_bbox")})), this.rtParam("outputWidth", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_width")})), this.rtParam("outputHeight", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_height")}))})));
    }

    @Test
    public void testRenderingTransformationWMSAutoMixed() throws IOException {
        String yaml = "feature-styles: \n- transform:\n    name: vec:Heatmap\n    params:\n      weightAttr: pop2000\n      radius: 100\n      pixelsPerCell: 10\n      outputBBOX: ${env('test')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("data", new Matcher[0]), this.rtParam("weightAttr", TestUtils.literal("pop2000")), this.rtParam("radius", TestUtils.literal(100)), this.rtParam("pixelsPerCell", TestUtils.literal(10)), this.rtParam("outputBBOX", TestUtils.function("env", new Matcher[]{TestUtils.literal("test")})), this.rtParam("outputWidth", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_width")})), this.rtParam("outputHeight", TestUtils.function("env", new Matcher[]{TestUtils.literal("wms_height")}))})));
    }

    @Test
    public void testNestedRenderingTransformation() throws IOException {
        String yaml = "feature-styles:\n- transform:\n    name: ras:Contour\n    params:\n      data: \n        name: vec:BarnesSurface\n        input: data\n        params:\n          valuAttr: MxTmp\n      levels:\n      - -5\n      - 0\n      - 5\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Expression tx = fs.getTransformation();
        Assert.assertNotNull((Object)tx);
        ProcessFunction pf = (ProcessFunction)tx;
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"ras:Contour")));
        Function param1 = (Function)pf.getParameters().get(1);
        Function param0 = (Function)pf.getParameters().get(0);
        MatcherAssert.assertThat((Object)param1, this.rtParam("levels", TestUtils.literal(-5), TestUtils.literal(0), TestUtils.literal(5)));
        MatcherAssert.assertThat((Object)param0, this.rtParam("data", Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"vec:BarnesSurface"))})));
        MatcherAssert.assertThat((Object)pf, (Matcher)Matchers.hasProperty((String)"parameters", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.rtParam("data", Matchers.allOf((Matcher)Matchers.instanceOf(ProcessFunction.class), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)"vec:BarnesSurface")))), this.rtParam("levels", TestUtils.literal(-5), TestUtils.literal(0), TestUtils.literal(5))})));
    }

    @Test
    public void testLabelShield() throws Exception {
        String yaml = "feature-styles:\n- name: name\n rules:\n - symbolizers:\n   - line:\n       stroke-color: '#555555'\n       stroke-width: 1.0\n    - text:\n       label: name\n       symbols:\n        - mark:\n           shape: circle\n           fill-color: '#995555'\n       geometry: ${geom}";
        Assert.assertNotNull((Object)yaml);
    }

    @Test
    public void testZoomSimple() throws IOException {
        String yaml = "grid:\n  initial-scale: 5000000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(0, 0) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(2500000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(1.0E7)))}));
    }

    @Test
    public void testZoomSimpleRange() throws IOException {
        String yaml = "grid:\n  initial-scale: 5000000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(1, 2) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        Rule r = (Rule)fs.rules().get(0);
        MatcherAssert.assertThat((Object)r, TestUtils.appliesToScale(2500000.0));
        MatcherAssert.assertThat((Object)r, TestUtils.appliesToScale(1250000.0));
        MatcherAssert.assertThat((Object)r, (Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)));
        MatcherAssert.assertThat((Object)r, (Matcher)Matchers.not(TestUtils.appliesToScale(625000.0)));
    }

    @Test
    public void testZoomSimpleWithDifferentInitial() throws IOException {
        String yaml = "grid:\n  initial-scale: 5000000\n  initial-level: 3\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(0, 0) + "\n  - zoom: " + YsldParseTest.tuple(3, 3) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(4.0E7), (Matcher)Matchers.not(TestUtils.appliesToScale(2.0E7)), (Matcher)Matchers.not(TestUtils.appliesToScale(8.0E7))), Matchers.allOf(TestUtils.appliesToScale(4.0E7), (Matcher)Matchers.not(TestUtils.appliesToScale(2.0E7)), (Matcher)Matchers.not(TestUtils.appliesToScale(8.0E7)))}));
    }

    @Test
    public void testZoomList() throws IOException {
        String yaml = "grid:\n  scales:\n  - 5000000\n  - 2000000\n  - 1000000\n  - 500000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(0, 0) + "\n  - zoom: " + YsldParseTest.tuple(2, 2) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0))), Matchers.allOf(TestUtils.appliesToScale(1000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)))}));
    }

    @Test
    public void testZoomListWithInitial() throws IOException {
        String yaml = "grid:\n  initial-level: 3\n  scales:\n  - 5000000\n  - 2000000\n  - 1000000\n  - 500000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(3, 3) + "\n  - zoom: " + YsldParseTest.tuple(5, 5) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0))), Matchers.allOf(TestUtils.appliesToScale(1000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)))}));
    }

    @Test
    public void testZoomListWithRanges() throws IOException {
        String yaml = "grid:\n  scales:\n  - 5000000\n  - 2000000\n  - 1000000\n  - 500000\n  - 200000\n  - 100000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(null, 1) + "\n  - zoom: " + YsldParseTest.tuple(2, 3) + "\n  - zoom: " + YsldParseTest.tuple(4, null) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), TestUtils.appliesToScale(2000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), TestUtils.appliesToScale(1000000.0), TestUtils.appliesToScale(500000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), TestUtils.appliesToScale(200000.0), TestUtils.appliesToScale(100000.0))}));
    }

    @Test
    public void testZoomListWithMinMaxKeywords() throws IOException {
        String yaml = "grid:\n  scales:\n  - 5000000\n  - 2000000\n  - 1000000\n  - 500000\n  - 200000\n  - 100000\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple("min", 1) + "\n  - zoom: " + YsldParseTest.tuple(2, 3) + "\n  - zoom: " + YsldParseTest.tuple(4, "max") + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), TestUtils.appliesToScale(2000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), TestUtils.appliesToScale(1000000.0), TestUtils.appliesToScale(500000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), TestUtils.appliesToScale(200000.0), TestUtils.appliesToScale(100000.0))}));
    }

    @Test
    public void testScaleWithMinMaxKeywords() throws IOException {
        String yaml = "feature-styles: \n- name: name\n  rules:\n  - scale: " + YsldParseTest.tuple(1500000, "max") + "\n  - scale: " + YsldParseTest.tuple(300000, 1500000) + "\n  - scale: " + YsldParseTest.tuple("min", 300000) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), TestUtils.appliesToScale(2000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), TestUtils.appliesToScale(1000000.0), TestUtils.appliesToScale(500000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), TestUtils.appliesToScale(200000.0), TestUtils.appliesToScale(100000.0))}));
    }

    @Test
    public void testScaleWithNull() throws IOException {
        String yaml = "feature-styles: \n- name: name\n  rules:\n  - scale: " + YsldParseTest.tuple(1500000, null) + "\n  - scale: " + YsldParseTest.tuple(300000, 1500000) + "\n  - scale: " + YsldParseTest.tuple(null, 300000) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf(TestUtils.appliesToScale(5000000.0), TestUtils.appliesToScale(2000000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), TestUtils.appliesToScale(1000000.0), TestUtils.appliesToScale(500000.0), (Matcher)Matchers.not(TestUtils.appliesToScale(200000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(100000.0))), Matchers.allOf((Matcher)Matchers.not(TestUtils.appliesToScale(5000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(2000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(1000000.0)), (Matcher)Matchers.not(TestUtils.appliesToScale(500000.0)), TestUtils.appliesToScale(200000.0), TestUtils.appliesToScale(100000.0))}));
    }

    @Test
    public void testZoomDefault() throws IOException {
        String yaml = "feature-styles: \n- name: name\n  rules:\n" + WGS84_TEST_RULES;
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        this.doTestForWGS84(sld);
    }

    @Test
    public void testNamed() throws IOException {
        String yaml = "grid:\n  name: WebMercator\nfeature-styles: \n- name: name\n  rules:\n" + GOOGLE_MERCATOR_TEST_RULES;
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        this.doTestForGoogleMercator(sld);
    }

    private void doTestForGoogleMercator(StyledLayerDescriptor sld) throws IOException {
        int i;
        double[] scaleDenominators = new double[this.GOOGLE_MERCATOR_PIXEL_SIZES.length];
        for (int i2 = 0; i2 < this.GOOGLE_MERCATOR_PIXEL_SIZES.length; ++i2) {
            scaleDenominators[i2] = this.OGC_DPI * this.INCHES_PER_METRE * this.GOOGLE_MERCATOR_PIXEL_SIZES[i2];
        }
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        for (i = 0; i < this.GOOGLE_MERCATOR_PIXEL_SIZES.length; ++i) {
            scaleDenominators[i] = this.OGC_DPI * this.INCHES_PER_METRE * this.GOOGLE_MERCATOR_PIXEL_SIZES[i];
        }
        MatcherAssert.assertThat((Object)fs.rules().size(), (Matcher)Matchers.is((Object)20));
        MatcherAssert.assertThat((Object)((Rule)fs.rules().get(0)), (Matcher)Matchers.allOf(TestUtils.appliesToScale(scaleDenominators[0]), (Matcher)Matchers.not(TestUtils.appliesToScale(scaleDenominators[1]))));
        MatcherAssert.assertThat((Object)((Rule)fs.rules().get(19)), (Matcher)Matchers.allOf(TestUtils.appliesToScale(scaleDenominators[19]), (Matcher)Matchers.not(TestUtils.appliesToScale(scaleDenominators[18]))));
        for (i = 1; i < 19; ++i) {
            MatcherAssert.assertThat((Object)((Rule)fs.rules().get(i)), (Matcher)Matchers.describedAs((String)"rule applies only to level %0 (%1)", (Matcher)Matchers.allOf(TestUtils.appliesToScale(scaleDenominators[i]), (Matcher)Matchers.not(TestUtils.appliesToScale(scaleDenominators[i + 1])), (Matcher)Matchers.not(TestUtils.appliesToScale(scaleDenominators[i + -1]))), (Object[])new Object[]{i, scaleDenominators[i]}));
        }
    }

    Matcher<Double> mCloseTo(final double value, final double epsilon) {
        return new BaseMatcher<Double>(){

            public boolean matches(Object arg0) {
                return Math.abs(value / (Double)arg0 - 1.0) <= epsilon;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("divided by ").appendValue((Object)value).appendText(" within ").appendValue((Object)epsilon).appendText(" of 1.");
            }
        };
    }

    @Test
    public void testWGS84Scales() throws Exception {
        ZoomContext context = WellKnownZoomContextFinder.getInstance().get("DEFAULT");
        for (int i = 0; i < this.WGS84_SCALE_DENOMS.length; ++i) {
            MatcherAssert.assertThat((Object)context.getScaleDenominator(i), this.mCloseTo(this.WGS84_SCALE_DENOMS[i], 1.0E-8));
        }
    }

    private void doTestForWGS84(StyledLayerDescriptor sld) throws IOException {
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        MatcherAssert.assertThat((Object)fs.rules().size(), (Matcher)Matchers.is((Object)21));
        Rule first = (Rule)fs.rules().get(0);
        MatcherAssert.assertThat((Object)first, (Matcher)Matchers.allOf(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[0]), (Matcher)Matchers.not(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[1]))));
        for (int i = 1; i < 20; ++i) {
            Rule r = (Rule)fs.rules().get(i);
            MatcherAssert.assertThat((Object)r, (Matcher)Matchers.describedAs((String)"rule applies only to level %0 (%1)", (Matcher)Matchers.allOf(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[i]), (Matcher)Matchers.not(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[i + 1])), (Matcher)Matchers.not(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[i + -1]))), (Object[])new Object[]{i, this.WGS84_SCALE_DENOMS[i]}));
        }
        Rule last = (Rule)fs.rules().get(20);
        MatcherAssert.assertThat((Object)last, (Matcher)Matchers.allOf(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[20]), (Matcher)Matchers.not(TestUtils.appliesToScale(this.WGS84_SCALE_DENOMS[19]))));
    }

    @Test
    public void testNamedWithFinder() throws IOException {
        String yaml = "grid:\n  name: test\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(0, 0);
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock(ZoomContextFinder.class);
        ZoomContext context = (ZoomContext)EasyMock.createMock(ZoomContext.class);
        EasyMock.expect((Object)finder.get("test")).andReturn((Object)context);
        EasyMock.expect((Object)context.getRange(Integer.valueOf(0), Integer.valueOf(0))).andReturn((Object)new ScaleRange(42.0, 64.0));
        EasyMock.replay((Object[])new Object[]{finder, context});
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml, Arrays.asList(finder), null);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        ((Rule)fs.rules().get(0)).getMaxScaleDenominator();
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"maxScaleDenominator", (Matcher)Matchers.closeTo((double)64.0, (double)1.0E-7)), (Matcher)Matchers.hasProperty((String)"minScaleDenominator", (Matcher)Matchers.closeTo((double)42.0, (double)1.0E-7)))}));
        EasyMock.verify((Object[])new Object[]{finder, context});
    }

    @Test
    public void testWellKnownWithCustomFinder() throws IOException {
        String yaml = "grid:\n  name: WebMercator\nfeature-styles: \n- name: name\n  rules:\n" + GOOGLE_MERCATOR_TEST_RULES;
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock(ZoomContextFinder.class);
        EasyMock.expect((Object)finder.get("WebMercator")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{finder});
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml, Arrays.asList(finder), null);
        this.doTestForGoogleMercator(sld);
        EasyMock.verify((Object[])new Object[]{finder});
    }

    @Test
    public void testCustomFinderOverridesWellKnown() throws IOException {
        String yaml = "grid:\n  name: WebMercator\nfeature-styles: \n- name: name\n  rules:\n  - zoom: " + YsldParseTest.tuple(0, 0);
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock(ZoomContextFinder.class);
        ZoomContext context = (ZoomContext)EasyMock.createMock(ZoomContext.class);
        EasyMock.expect((Object)finder.get("WebMercator")).andReturn((Object)context);
        EasyMock.expect((Object)context.getRange(Integer.valueOf(0), Integer.valueOf(0))).andReturn((Object)new ScaleRange(42.0, 64.0));
        EasyMock.replay((Object[])new Object[]{finder, context});
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml, Arrays.asList(finder), null);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        ((Rule)fs.rules().get(0)).getMaxScaleDenominator();
        MatcherAssert.assertThat((Object)fs.rules(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.hasProperty((String)"maxScaleDenominator", (Matcher)Matchers.closeTo((double)64.0, (double)1.0E-7)), (Matcher)Matchers.hasProperty((String)"minScaleDenominator", (Matcher)Matchers.closeTo((double)42.0, (double)1.0E-7)))}));
        EasyMock.verify((Object[])new Object[]{finder, context});
    }

    @Test
    public void testParseNoStrokeFillDefaults() throws Exception {
        String yaml = "polygon: \n  fill-color: blue\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PolygonSymbolizer p = (PolygonSymbolizer)SLD.symbolizers((Style)SLD.defaultStyle((StyledLayerDescriptor)sld))[0];
        Assert.assertEquals((Object)Color.BLUE, (Object)SLD.color((Fill)SLD.fill((PolygonSymbolizer)p)));
        Assert.assertNull((Object)SLD.stroke((PolygonSymbolizer)p));
        yaml = "polygon: \n  stroke-color: blue\n";
        sld = Ysld.parse((Object)yaml);
        p = (PolygonSymbolizer)SLD.symbolizers((Style)SLD.defaultStyle((StyledLayerDescriptor)sld))[0];
        Assert.assertEquals((Object)Color.BLUE, (Object)SLD.color((Stroke)SLD.stroke((PolygonSymbolizer)p)));
        Assert.assertNull((Object)SLD.fill((PolygonSymbolizer)p));
    }

    static String tuple(Object ... values) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        String join = "";
        for (Object o : values) {
            builder.append(join);
            join = ", ";
            if (o == null) {
                builder.append("null");
                continue;
            }
            String s = o.toString();
            if (s.isEmpty() || s.startsWith("#") || s.equalsIgnoreCase("null")) {
                builder.append(String.format("'%s'", s));
                continue;
            }
            builder.append(s);
        }
        builder.append("]");
        return builder.toString();
    }

    @Test
    public void testColourMap() throws Exception {
        String yaml = "raster: \n  color-map:\n    type: values\n    entries:\n    - " + YsldParseTest.tuple("#ff0000", "1.0", "0", "start") + "\n    - " + YsldParseTest.tuple("#00ff00", "1.0", "500", "middle") + "\n    - " + YsldParseTest.tuple("#0000ff", "1.0", "1000", "end") + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        org.opengis.style.RasterSymbolizer symb = (org.opengis.style.RasterSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        ColorMap map = (ColorMap)symb.getColorMap();
        Color colour1 = (Color)map.getColorMapEntry(0).getColor().evaluate(null);
        Color colour2 = (Color)map.getColorMapEntry(1).getColor().evaluate(null);
        Color colour3 = (Color)map.getColorMapEntry(2).getColor().evaluate(null);
        MatcherAssert.assertThat((Object)colour1, (Matcher)Matchers.is((Object)Color.RED));
        MatcherAssert.assertThat((Object)colour2, (Matcher)Matchers.is((Object)Color.GREEN));
        MatcherAssert.assertThat((Object)colour3, (Matcher)Matchers.is((Object)Color.BLUE));
    }

    @Test
    public void testColourMapExpression() throws Exception {
        String yaml = "raster: \n  color-map:\n    type: values\n    entries:\n    - " + YsldParseTest.tuple("#ff0000", "1.0", "0", "start") + "\n    - " + YsldParseTest.tuple("#00ff00", "1.0", "500", "middle") + "\n    - " + YsldParseTest.tuple("#0000ff", "'${pow(0.75, 1.2)}'", "1000", "end") + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        org.opengis.style.RasterSymbolizer symb = (org.opengis.style.RasterSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        ColorMap map = (ColorMap)symb.getColorMap();
        MatcherAssert.assertThat((Object)map.getColorMapEntry(2).getOpacity(), TestUtils.function("pow", TestUtils.literal(0.75), TestUtils.literal(1.2)));
    }

    @Test
    public void testColourMapEmpty() throws Exception {
        String yaml = "raster: \n  color-map:\n    type: values\n    entries:\n    - " + YsldParseTest.tuple("#ff0000", "1.0", "0", "start") + "\n    - " + YsldParseTest.tuple("#00ff00", "", "500", "middle") + "\n    - " + YsldParseTest.tuple("#0000ff", null, "1000", "end") + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        org.opengis.style.RasterSymbolizer symb = (org.opengis.style.RasterSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        ColorMap map = (ColorMap)symb.getColorMap();
        this.LOG.fine(map.getColorMapEntry(0).getColor().evaluate(null).toString());
        Color colour1 = (Color)map.getColorMapEntry(0).getColor().evaluate(null);
        Color colour2 = (Color)map.getColorMapEntry(1).getColor().evaluate(null);
        Color colour3 = (Color)map.getColorMapEntry(2).getColor().evaluate(null);
        MatcherAssert.assertThat((Object)colour1, (Matcher)Matchers.is((Object)Color.RED));
        MatcherAssert.assertThat((Object)colour2, (Matcher)Matchers.is((Object)Color.GREEN));
        MatcherAssert.assertThat((Object)colour3, (Matcher)Matchers.is((Object)Color.BLUE));
    }

    @Test
    public void testLabelLiteral() throws Exception {
        String yaml = "text: \n  label: test literal\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression label = symb.getLabel();
        MatcherAssert.assertThat((Object)label, (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(Literal.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)"test literal"))));
    }

    @Test
    public void testLabelEmbeded() throws Exception {
        String yaml = "text: \n  label: literal0${attribute1}literal2\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression label = symb.getLabel();
        MatcherAssert.assertThat((Object)label, (Matcher)Matchers.instanceOf(ConcatenateFunction.class));
        List params = ((ConcatenateFunction)label).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Expression)params.get(0)), TestUtils.literal(Matchers.equalTo((Object)"literal0")));
        MatcherAssert.assertThat((Object)((Expression)params.get(1)), TestUtils.attribute("attribute1"));
        MatcherAssert.assertThat((Object)((Expression)params.get(2)), TestUtils.literal(Matchers.equalTo((Object)"literal2")));
    }

    @Test
    public void testLabelAttribute() throws Exception {
        String yaml = "text: \n  label: ${testAttribute}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression label = symb.getLabel();
        MatcherAssert.assertThat((Object)label, TestUtils.attribute("testAttribute"));
    }

    @Test
    public void testExpressionLiteral() throws Exception {
        String yaml = "text: \n  geometry: test literal\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getGeometry();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(Literal.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)Matchers.equalTo((Object)"test literal"))));
    }

    @Test
    public void testExpressionEmbeded() throws Exception {
        String yaml = "text: \n  geometry: literal0${attribute1}literal2\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getGeometry();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.instanceOf(ConcatenateFunction.class));
        List params = ((ConcatenateFunction)expr).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Expression)params.get(0)), TestUtils.literal(Matchers.equalTo((Object)"literal0")));
        MatcherAssert.assertThat((Object)((Expression)params.get(1)), TestUtils.attribute("attribute1"));
        MatcherAssert.assertThat((Object)((Expression)params.get(2)), TestUtils.literal(Matchers.equalTo((Object)"literal2")));
    }

    @Test
    public void testExpressionLong() throws Exception {
        String yaml = "polygon:\n  fill-color: ${recode(MAPCOLOR7, 1.0, '#FFC3C3', 2.0, '#FFE3C3', 3.0, '#FFFFC3', 4.0, '#C3FFE3', 5.0, '#C3FFFF', 6.0, '#C3C3FF', 7.0, '#BFC3FF')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        PolygonSymbolizer symb = (PolygonSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getFill().getColor();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.instanceOf(RecodeFunction.class));
        List params = ((RecodeFunction)expr).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)15));
        int i = 0;
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.attribute("MAPCOLOR7"));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)1.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFC3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)2.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFE3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)3.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFFFC3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)4.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFE3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)5.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFFF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)6.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3C3FF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)7.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("BFC3FF")));
    }

    @Test
    public void testExpressionLongBreak() throws Exception {
        String yaml = "polygon:\n  fill-color: ${recode(MAPCOLOR7, \n    1.0, '#FFC3C3', \n    2.0, '#FFE3C3', \n    3.0, '#FFFFC3', \n    4.0, '#C3FFE3', \n    5.0, '#C3FFFF', \n    6.0, '#C3C3FF', \n    7.0, '#BFC3FF')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        PolygonSymbolizer symb = (PolygonSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getFill().getColor();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.instanceOf(RecodeFunction.class));
        List params = ((RecodeFunction)expr).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)15));
        int i = 0;
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.attribute("MAPCOLOR7"));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)1.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFC3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)2.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFE3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)3.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFFFC3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)4.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFE3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)5.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFFF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)6.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3C3FF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)7.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("BFC3FF")));
    }

    @Ignore
    @Test
    public void testExpressionLongBreakFolded() throws Exception {
        String yaml = "polygon:\n  fill-color: >\n    ${recode(MAPCOLOR7, \n    1.0, '#FFC3C3', \n    2.0, '#FFE3C3', \n    3.0, '#FFFFC3', \n    4.0, '#C3FFE3', \n    5.0, '#C3FFFF', \n    6.0, '#C3C3FF', \n    7.0, '#BFC3FF')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        PolygonSymbolizer symb = (PolygonSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getFill().getColor();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.instanceOf(RecodeFunction.class));
        List params = ((RecodeFunction)expr).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)15));
        int i = 0;
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.attribute("MAPCOLOR7"));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)1.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFC3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)2.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFE3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)3.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFFFC3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)4.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFE3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)5.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFFF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)6.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3C3FF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)7.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("BFC3FF")));
    }

    @Ignore
    @Test
    public void testExpressionLongBreakPreserved() throws Exception {
        String yaml = "polygon:\n  fill-color: |\n    ${recode(MAPCOLOR7, \n    1.0, '#FFC3C3', \n    2.0, '#FFE3C3', \n    3.0, '#FFFFC3', \n    4.0, '#C3FFE3', \n    5.0, '#C3FFFF', \n    6.0, '#C3C3FF', \n    7.0, '#BFC3FF')}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        PolygonSymbolizer symb = (PolygonSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getFill().getColor();
        MatcherAssert.assertThat((Object)expr, (Matcher)Matchers.instanceOf(RecodeFunction.class));
        List params = ((RecodeFunction)expr).getParameters();
        MatcherAssert.assertThat((Object)params.size(), (Matcher)Matchers.is((Object)15));
        int i = 0;
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.attribute("MAPCOLOR7"));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)1.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFC3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)2.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFE3C3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)3.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("FFFFC3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)4.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFE3")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)5.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3FFFF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)6.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("C3C3FF")));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(Matchers.equalTo((Object)7.0)));
        MatcherAssert.assertThat((Object)((Expression)params.get(i++)), TestUtils.literal(TestUtils.isColor("BFC3FF")));
    }

    @Test
    public void testExpressionAttribute() throws Exception {
        String yaml = "text: \n  geometry: ${testAttribute}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fs = (FeatureTypeStyle)SLD.defaultStyle((StyledLayerDescriptor)sld).featureTypeStyles().get(0);
        TextSymbolizer symb = (TextSymbolizer)((Rule)fs.rules().get(0)).symbolizers().get(0);
        Expression expr = symb.getGeometry();
        MatcherAssert.assertThat((Object)expr, TestUtils.attribute("testAttribute"));
    }

    @Test
    public void testBadExpression() throws Exception {
        String yaml = "polygon: \n  stroke-width: ${round(foo) 1000}\n";
        try {
            Ysld.parse((Object)yaml);
            Assert.fail((String)"Bad expression should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDynamicColor() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: ${colourAttribute}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.attribute("colourAttribute"));
    }

    @Test
    public void testEvilExpression1() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: \\$\\}\\\\\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(Matchers.equalTo((Object)"$}\\")));
    }

    @Test
    public void testColorHex() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: 0x001122\n      stroke-color: 0x334455\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("001122")));
        MatcherAssert.assertThat((Object)SLD.stroke((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("334455")));
    }

    @Test
    public void testColorQuotedHex() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: '0x001122'\n      stroke-color: '0x334455'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("001122")));
        MatcherAssert.assertThat((Object)SLD.stroke((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("334455")));
    }

    @Test
    public void testColorQuotedHash() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: '#001122'\n      stroke-color: '#334455'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("001122")));
        MatcherAssert.assertThat((Object)SLD.stroke((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("334455")));
    }

    @Test
    public void testColorQuotedBare() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: '001122'\n      stroke-color: '334455'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("001122")));
        MatcherAssert.assertThat((Object)SLD.stroke((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("334455")));
    }

    @Test
    public void testColorSexegesimal() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: 1:17:40:20:15\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)SLD.fill((PointSymbolizer)p).getColor(), TestUtils.literal(TestUtils.isColor("FFFFFF")));
    }

    @Test
    public void testRasterBandSelectionGray() throws Exception {
        String yaml = "raster:\n  channels:\n    gray:\n      name: foo\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer r = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        SelectedChannelType grayChannel = r.getChannelSelection().getGrayChannel();
        MatcherAssert.assertThat((Object)((String)grayChannel.getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"foo"));
        MatcherAssert.assertThat((Object)grayChannel.getContrastEnhancement(), YsldParseTest.nullContrast());
    }

    @Test
    public void testRasterBandSelectionGreyWithContrast() throws Exception {
        String yaml = "raster:\n  channels:\n    gray:\n      name: foo\n      contrast-enhancement:\n        mode: normalize\n        gamma: 1.2\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer r = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        SelectedChannelType grayChannel = r.getChannelSelection().getGrayChannel();
        MatcherAssert.assertThat((Object)((String)grayChannel.getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"foo"));
        MatcherAssert.assertThat((Object)grayChannel.getContrastEnhancement().getGammaValue(), TestUtils.literal(Matchers.equalTo((Object)"1.2")));
        MatcherAssert.assertThat((Object)grayChannel.getContrastEnhancement().getMethod(), (Matcher)Matchers.equalTo((Object)ContrastMethod.NORMALIZE));
    }

    static Matcher<ContrastEnhancement> nullContrast() {
        return Matchers.describedAs((String)"Null Contrast Enhancement", (Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"gammaValue", TestUtils.nilExpression()), (Matcher)Matchers.hasProperty((String)"method", (Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.is((Object)ContrastMethod.NONE))))), (Object[])new Object[0]);
    }

    @Test
    public void testRasterBandSelectionRGB() throws Exception {
        String yaml = "raster:\n  channels:\n    red:\n      name: foo\n    green:\n      name: bar\n      contrast-enhancement:\n        mode: normalize\n    blue:\n      name: baz\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer r = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        SelectedChannelType[] rgbChannels = r.getChannelSelection().getRGBChannels();
        MatcherAssert.assertThat((Object)((String)rgbChannels[0].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"foo"));
        MatcherAssert.assertThat((Object)((String)rgbChannels[1].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"bar"));
        MatcherAssert.assertThat((Object)((String)rgbChannels[2].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"baz"));
        MatcherAssert.assertThat((Object)rgbChannels[0].getContrastEnhancement(), YsldParseTest.nullContrast());
        MatcherAssert.assertThat((Object)rgbChannels[1].getContrastEnhancement().getGammaValue(), TestUtils.nilExpression());
        MatcherAssert.assertThat((Object)rgbChannels[1].getContrastEnhancement().getMethod(), (Matcher)Matchers.equalTo((Object)ContrastMethod.NORMALIZE));
        MatcherAssert.assertThat((Object)rgbChannels[2].getContrastEnhancement(), YsldParseTest.nullContrast());
    }

    @Test
    public void testRasterBandSelectionGrayTerse() throws Exception {
        String yaml = "raster:\n  channels:\n    gray: 1\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer r = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        SelectedChannelType grayChannel = r.getChannelSelection().getGrayChannel();
        MatcherAssert.assertThat((Object)((String)grayChannel.getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)grayChannel.getContrastEnhancement(), YsldParseTest.nullContrast());
    }

    @Test
    public void testRasterBandSelectionRGBTerse() throws Exception {
        String yaml = "raster:\n  channels:\n    red: 1\n    green: 2\n    blue: 3\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer r = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        SelectedChannelType[] rgbChannels = r.getChannelSelection().getRGBChannels();
        MatcherAssert.assertThat((Object)((String)rgbChannels[0].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)rgbChannels[2].getContrastEnhancement(), YsldParseTest.nullContrast());
        MatcherAssert.assertThat((Object)((String)rgbChannels[1].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)rgbChannels[2].getContrastEnhancement(), YsldParseTest.nullContrast());
        MatcherAssert.assertThat((Object)((String)rgbChannels[2].getChannelName().evaluate(null, String.class)), (Matcher)Matchers.equalTo((Object)"3"));
        MatcherAssert.assertThat((Object)rgbChannels[2].getContrastEnhancement(), YsldParseTest.nullContrast());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBandSelectionExpression() throws Exception {
        String yaml = "feature-styles:\n- rules:\n  - symbolizers:\n    - raster:\n        channels:\n          gray:\n            name: ${env('B1','1')}";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        RasterSymbolizer raster = SLD.rasterSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Expression name = raster.getChannelSelection().getGrayChannel().getChannelName();
        Assert.assertEquals((Object)"1", (Object)name.evaluate(null, String.class));
        try {
            EnvFunction.setLocalValue((String)"B1", (Object)"2");
            Assert.assertEquals((Object)"2", (Object)name.evaluate(null, String.class));
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testMarkOpacity() throws Exception {
        String yaml = "point: \n  symbols: \n  - mark: \n      fill-color: '#FF0000'\n      fill-opacity: 0.5\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)((Mark)p.getGraphic().graphicalSymbols().get(0)).getFill().getOpacity(), TestUtils.literal(TestUtils.lexEqualTo(0.5)));
    }

    @Test
    public void testLineOffset() throws Exception {
        String yaml = "line:\n  stroke-color: '#555555'\n  stroke-width: 1.0\n  offset: 5";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer l = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)l.getPerpendicularOffset(), (Matcher)Matchers.is(TestUtils.literal(5)));
    }

    @Test
    public void testPointDisplacement() throws Exception {
        String yaml = "point: \n  displacement: " + YsldParseTest.tuple(10, 42) + "\n  symbols: \n  - mark: \n      fill-color: '#FF0000'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p.getGraphic().getDisplacement(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"displacementX", TestUtils.literal(10)), (Matcher)Matchers.hasProperty((String)"displacementY", TestUtils.literal(42))));
    }

    @Test
    public void testPointAnchor() throws Exception {
        String yaml = "point: \n  anchor: " + YsldParseTest.tuple(0.75, 0.25) + "\n  symbols: \n  - mark: \n      fill-color: '#FF0000'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p.getGraphic().getAnchorPoint(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"anchorPointX", TestUtils.literal(0.75)), (Matcher)Matchers.hasProperty((String)"anchorPointY", TestUtils.literal(0.25))));
    }

    @Test
    public void testTextDisplacement() throws Exception {
        String yaml = "text: \n  displacement: " + YsldParseTest.tuple(10, 42) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        TextSymbolizer p = SLD.textSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)((PointPlacement)p.getLabelPlacement()).getDisplacement(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"displacementX", TestUtils.literal(10)), (Matcher)Matchers.hasProperty((String)"displacementY", TestUtils.literal(42))));
    }

    @Test
    public void testTextAnchor() throws Exception {
        String yaml = "text: \n  anchor: " + YsldParseTest.tuple(0.75, 0.25) + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        TextSymbolizer t = SLD.textSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)((PointPlacement)t.getLabelPlacement()).getAnchorPoint(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"anchorPointX", TestUtils.literal(0.75)), (Matcher)Matchers.hasProperty((String)"anchorPointY", TestUtils.literal(0.25))));
    }

    @Test
    public void testTextPlacementType() throws Exception {
        String yaml = "text: \n  placement: line\n  offset: 4\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        TextSymbolizer t = SLD.textSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)t.getLabelPlacement(), (Matcher)Matchers.instanceOf(LinePlacement.class));
        MatcherAssert.assertThat((Object)((LinePlacement)t.getLabelPlacement()).getPerpendicularOffset(), TestUtils.literal(4));
    }

    @Test
    public void testTextGraphicDisplacement() throws Exception {
        String yaml = "text:\n    label: ${name}\n    displacement: " + YsldParseTest.tuple(42, 64) + "\n    graphic:\n      displacement: " + YsldParseTest.tuple(10, 15) + "\n      symbols:\n      - mark:\n          shape: circle\n          fill-color: '#995555'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        TextSymbolizer2 p = (TextSymbolizer2)SLD.textSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p.getGraphic().getDisplacement(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"displacementX", TestUtils.literal(10)), (Matcher)Matchers.hasProperty((String)"displacementY", TestUtils.literal(15))));
        MatcherAssert.assertThat((Object)((PointPlacement)p.getLabelPlacement()).getDisplacement(), (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"displacementX", TestUtils.literal(42)), (Matcher)Matchers.hasProperty((String)"displacementY", TestUtils.literal(64))));
    }

    @Test
    public void testRelativeExternalGraphicNoResolver() throws Exception {
        String yaml = "feature-styles:\n- name: name\n  rules:\n  - symbolizers:\n    - point:\n        size: 32\n        symbols:\n        - external:\n            url: smileyface.png\n            format: image/png\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)((GraphicalSymbol)p.getGraphic().graphicalSymbols().get(0)), (Matcher)Matchers.instanceOf(ExternalGraphic.class));
        ExternalGraphic eg = (ExternalGraphic)p.getGraphic().graphicalSymbols().get(0);
        MatcherAssert.assertThat((Object)eg.getLocation(), (Matcher)Matchers.equalTo((Object)new URL("file:smileyface.png")));
        MatcherAssert.assertThat((Object)eg.getOnlineResource().getLinkage(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)new URI("smileyface.png")), (Matcher)Matchers.equalTo((Object)new URI("file:smileyface.png"))));
    }

    @Test
    public void testRelativeExternalGraphicWithResolver() throws Exception {
        String yaml = "feature-styles:\n- name: name\n  rules:\n  - symbolizers:\n    - point:\n        size: 32\n        symbols:\n        - external:\n            url: smileyface.png\n            format: image/png\n";
        ResourceLocator locator = (ResourceLocator)EasyMock.createMock(ResourceLocator.class);
        EasyMock.expect((Object)locator.locateResource("smileyface.png")).andReturn((Object)new URL("http://itworked/smileyface.png"));
        EasyMock.replay((Object[])new Object[]{locator});
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml, Collections.emptyList(), (ResourceLocator)locator);
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)((GraphicalSymbol)p.getGraphic().graphicalSymbols().get(0)), (Matcher)Matchers.instanceOf(ExternalGraphic.class));
        ExternalGraphic eg = (ExternalGraphic)p.getGraphic().graphicalSymbols().get(0);
        MatcherAssert.assertThat((Object)eg.getLocation(), (Matcher)Matchers.equalTo((Object)new URL("http://itworked/smileyface.png")));
        MatcherAssert.assertThat((Object)eg.getOnlineResource().getLinkage(), (Matcher)Matchers.equalTo((Object)new URI("http://itworked/smileyface.png")));
        EasyMock.verify((Object[])new Object[]{locator});
    }

    @Test
    public void testTextSymbolizerPriority() throws Exception {
        String yaml = "text:\n    label: ${name}\n    priority: ${pop}\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        TextSymbolizer2 p = (TextSymbolizer2)SLD.textSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Assert.assertNotNull((Object)p.getPriority());
        Assert.assertTrue((boolean)(p.getPriority() instanceof PropertyName));
        Assert.assertEquals((Object)"pop", (Object)((PropertyName)p.getPriority()).getPropertyName());
    }

    @Test
    public void testStrokeLinejoinDefault() throws Exception {
        String yaml = "line:\n    stroke-color: \"#ff0000\"\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"stroke", (Matcher)Matchers.hasProperty((String)"lineJoin", TestUtils.literal("miter"))));
    }

    @Test
    public void testStrokeLinejoinBevel() throws Exception {
        String yaml = "line:\n    stroke-linejoin: bevel\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"stroke", (Matcher)Matchers.hasProperty((String)"lineJoin", TestUtils.literal("bevel"))));
    }

    @Test
    public void testStrokeLinejoinMitre() throws Exception {
        String yaml = "line:\n    stroke-linejoin: mitre\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"stroke", (Matcher)Matchers.hasProperty((String)"lineJoin", TestUtils.literal("mitre"))));
    }

    @Test
    public void testSuite54() throws IOException {
        try (InputStream input = YsldTests.ysld("poly", "suite-54.ysld");){
            StyledLayerDescriptor sld = Ysld.parse((Object)input);
            Style style = SLD.styles((StyledLayerDescriptor)sld)[0];
            TextSymbolizer text = SLD.textSymbolizer((Style)style);
            LabelPlacement placement = text.getLabelPlacement();
            Assert.assertNotNull((Object)placement);
        }
    }

    @Test
    public void testMultiplyCompositeOnFeatureTypeStyle() throws Exception {
        String yaml = "feature-styles:\n- name: name\n  x-composite: multiply\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fts = SLD.featureTypeStyles((StyledLayerDescriptor)sld)[0];
        MatcherAssert.assertThat((Object)fts, (Matcher)Matchers.hasProperty((String)"options", (Matcher)Matchers.hasEntry((Object)"composite", (Object)"multiply")));
    }

    @Test
    public void testMultiplyCompositeOnSymbolizer() throws Exception {
        String yaml = "line:\n  x-composite: multiply\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"options", (Matcher)Matchers.hasEntry((Object)"composite", (Object)"multiply")));
    }

    @Test
    public void testMultiplyCompositeBaseOnFeatureTypeStyle() throws Exception {
        String yaml = "feature-styles:\n- name: name\n  x-composite-base: true\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        FeatureTypeStyle fts = SLD.featureTypeStyles((StyledLayerDescriptor)sld)[0];
        MatcherAssert.assertThat((Object)fts, (Matcher)Matchers.hasProperty((String)"options", (Matcher)Matchers.hasEntry((Object)"composite-base", (Object)"true")));
    }

    @Test
    public void testMultiplyCompositeBaseOnSymbolizer() throws Exception {
        String yaml = "line:\n  x-composite-base: true\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"options", (Matcher)Matchers.hasEntry((Object)"composite-base", (Object)"true")));
    }

    @Test
    public void testStrokeGraphic() throws Exception {
        String yaml = "line:\n  stroke-graphic:\n    symbols:\n    - mark:\n        shape: circle\n        fill-color: '#995555'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"stroke", (Matcher)Matchers.hasProperty((String)"graphicStroke")));
        Graphic g = p.getStroke().getGraphicStroke();
        List symbols = g.graphicalSymbols();
        ((Mark)symbols.get(0)).getFill().getColor();
        MatcherAssert.assertThat((Object)symbols, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(Mark.class), (Matcher)Matchers.hasProperty((String)"wellKnownName", TestUtils.literal("circle")), (Matcher)Matchers.hasProperty((String)"fill", (Matcher)Matchers.hasProperty((String)"color", TestUtils.literal(TestUtils.isColor("995555")))))}));
    }

    @Test
    public void testStrokeGraphicFill() throws Exception {
        String yaml = "line:\n  stroke-graphic-fill:\n    symbols:\n    - mark:\n        shape: circle\n        fill-color: '#995555'\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"stroke", (Matcher)Matchers.hasProperty((String)"graphicFill")));
        Graphic g = p.getStroke().getGraphicFill();
        List symbols = g.graphicalSymbols();
        ((Mark)symbols.get(0)).getFill().getColor();
        MatcherAssert.assertThat((Object)symbols, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.allOf((Matcher)Matchers.instanceOf(Mark.class), (Matcher)Matchers.hasProperty((String)"wellKnownName", TestUtils.literal("circle")), (Matcher)Matchers.hasProperty((String)"fill", (Matcher)Matchers.hasProperty((String)"color", TestUtils.literal(TestUtils.isColor("995555")))))}));
    }

    @Test
    public void testUomMetre() throws Exception {
        String yaml = "line:\n  uom: metre\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.METRE.getUnit())));
    }

    @Test
    public void testUomFoot() throws Exception {
        String yaml = "line:\n  uom: foot\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.FOOT.getUnit())));
    }

    @Test
    public void testUomPixel() throws Exception {
        String yaml = "line:\n  uom: pixel\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.PIXEL.getUnit())));
    }

    @Test
    public void testUomSymbol() throws Exception {
        String yaml = "line:\n  uom: m\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.METRE.getUnit())));
    }

    @Test
    public void testUomSEURL() throws Exception {
        String yaml = "line:\n  uom: " + UomOgcMapping.FOOT.getSEString() + "\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.FOOT.getUnit())));
    }

    @Test
    public void testUomAmerican() throws Exception {
        String yaml = "line:\n  uom: meter\n";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        LineSymbolizer p = SLD.lineSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        MatcherAssert.assertThat((Object)p, (Matcher)Matchers.hasProperty((String)"unitOfMeasure", (Matcher)Matchers.sameInstance((Object)UomOgcMapping.METRE.getUnit())));
    }

    @Test
    public void testLegend() throws Exception {
        String yaml = "feature-styles:\n- rules:\n  - legend:\n      symbols:\n      - external:\n          url: smileyface.png\n          format: image/png\n    symbolizers:\n    - point:\n        symbols:\n        - mark:\n            shape: circle\n            fill-color: '#FF0000'";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule rule = SLD.rules((Style)SLD.defaultStyle((StyledLayerDescriptor)sld))[0];
        MatcherAssert.assertThat((Object)((GraphicalSymbol)rule.getLegend().graphicalSymbols().get(0)), (Matcher)Matchers.instanceOf(ExternalGraphic.class));
        ExternalGraphic legend = (ExternalGraphic)rule.getLegend().graphicalSymbols().get(0);
        Assert.assertEquals((Object)new URL("file:smileyface.png"), (Object)legend.getLocation());
        Assert.assertEquals((Object)"image/png", (Object)legend.getFormat());
        PointSymbolizer p = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Assert.assertEquals((Object)"circle", (Object)SLD.wellKnownName((org.geotools.styling.Mark)SLD.mark((PointSymbolizer)p)));
        Assert.assertEquals((Object)Color.RED, (Object)SLD.color((Fill)SLD.fill((PointSymbolizer)p)));
    }

    @Test
    public void testDeserializationAttempt() throws Exception {
        try {
            String yaml = "!!java.util.Date\ndate: 25\nmonth: 12\nyear: 2016";
            Ysld.parse((Object)yaml);
            Assert.fail((String)"Expected parsing to fail");
        }
        catch (ComposerException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Global tag is not allowed"));
        }
    }

    @Test
    public void testRuleVendorOption() throws Exception {
        String yaml = "feature-styles:\n- rules:\n  - x-foo: bar";
        StyledLayerDescriptor sld = Ysld.parse((Object)yaml);
        Rule rule = SLD.rules((Style)SLD.defaultStyle((StyledLayerDescriptor)sld))[0];
        MatcherAssert.assertThat((Object)rule.getOptions(), (Matcher)Matchers.hasEntry((Object)"foo", (Object)"bar"));
    }
}

