/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.ysld.encode.LineSymbolizerEncoder;
import org.geotools.ysld.encode.PointSymblolizerEncoder;
import org.geotools.ysld.encode.PolygonSymbolizerEncoder;
import org.geotools.ysld.encode.RasterSymbolizerEncoder;
import org.geotools.ysld.encode.TextSymbolizerEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class SymbolizersEncoder
extends YsldEncodeHandler<Symbolizer> {
    public SymbolizersEncoder(Rule rule) {
        super(rule.symbolizers().iterator());
    }

    @Override
    protected void encode(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.push("point").inline(new PointSymblolizerEncoder((PointSymbolizer)sym));
        } else if (sym instanceof LineSymbolizer) {
            this.push("line").inline(new LineSymbolizerEncoder((LineSymbolizer)sym));
        } else if (sym instanceof PolygonSymbolizer) {
            this.push("polygon").inline(new PolygonSymbolizerEncoder((PolygonSymbolizer)sym));
        } else if (sym instanceof TextSymbolizer) {
            this.push("text").inline(new TextSymbolizerEncoder((TextSymbolizer)sym));
        } else if (sym instanceof RasterSymbolizer) {
            this.push("raster").inline(new RasterSymbolizerEncoder((RasterSymbolizer)sym));
        }
    }

    SymbolizersEncoder encode(LineSymbolizer sym) {
        return this;
    }

    SymbolizersEncoder encode(PolygonSymbolizer sym) {
        return this;
    }

    SymbolizersEncoder encode(RasterSymbolizer sym) {
        return this;
    }
}

