/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import org.geotools.ysld.validate.RangeValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.yaml.snakeyaml.events.ScalarEvent;

public class ScaleValidator
extends RangeValidator<Double> {
    @Override
    Double parse(String s) throws IllegalArgumentException {
        return Double.parseDouble(s);
    }

    @Override
    protected void validateParsed(Double parsed, ScalarEvent evt, YsldValidateContext context) {
        if (parsed.compareTo(0.0) < 0) {
            context.error("scale denominator must be non-negative", evt.getStartMark());
        } else if (parsed.isNaN()) {
            context.error("scale denominator is not a number", evt.getStartMark());
        }
    }
}

