/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import java.util.ArrayList;
import java.util.List;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.ysld.validate.ScalarValidator;
import org.geotools.ysld.validate.StatefulValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class TupleValidator
extends StatefulValidator
implements Cloneable {
    State state = State.NEW;
    int valuesValidated = 0;
    List<ScalarValidator> subValidators;

    public TupleValidator(List<? extends ScalarValidator> subValidators) {
        this.subValidators = new ArrayList<ScalarValidator>(subValidators);
    }

    @Override
    public void sequence(SequenceStartEvent evt, YsldValidateContext context) {
        if (this.state == State.NEW) {
            this.state = State.STARTED;
        } else {
            context.error("Unexpected Start of Sequence", evt.getStartMark());
        }
    }

    @Override
    public void endSequence(SequenceEndEvent evt, YsldValidateContext context) {
        if (this.state != State.STARTED) {
            context.error("Unexpected End of Sequence", evt.getStartMark());
        } else if (this.valuesValidated != this.getSubValidators().size()) {
            context.error(String.format("Expected tuple of size %d but was %d", this.getSubValidators().size(), this.valuesValidated), evt.getStartMark());
        }
        this.state = State.DONE;
        context.pop();
    }

    protected List<ScalarValidator> getSubValidators() {
        return this.subValidators;
    }

    @Override
    public void scalar(ScalarEvent evt, YsldValidateContext context) {
        String val = evt.getValue();
        switch (this.state) {
            case STARTED: {
                try {
                    context.push(this.getSubValidators().get(this.valuesValidated));
                    context.peek().scalar(evt, context);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++this.valuesValidated;
                break;
            }
            default: {
                context.error(String.format("Unexpected scalar '%s'", val), evt.getStartMark());
            }
        }
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public TupleValidator clone() {
        return new TupleValidator(this.subValidators);
    }

    @Override
    void reset() {
        if (this.state != State.NEW && this.state != State.DONE) {
            throw new IllegalStateException("TupleValidator.reset() called in invalid state: " + this.state.toString());
        }
        this.state = State.NEW;
        this.valuesValidated = 0;
    }

    @Override
    public void alias(AliasEvent evt, YsldValidateContext context) {
        switch (this.state) {
            case NEW: {
                this.state = State.DONE;
                context.pop();
                break;
            }
            case STARTED: {
                ++this.valuesValidated;
                break;
            }
            default: {
                context.error(String.format("Unexpected alias '%s'", evt.getAnchor()), evt.getStartMark());
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        DONE;

    }
}

