/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easymock.EasyMock;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.Ysld;
import org.geotools.ysld.parse.ZoomContext;
import org.geotools.ysld.parse.ZoomContextFinder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class YsldValidateTest {
    static final String[] EXPRESSION_KEYS = new String[]{"offset", "shape", "gamma", "stroke-width", "stroke-opacity", "stroke-linejoin", "stroke-linecap", "stroke-dashoffset", "geometry", "label", "font-family", "font-size", "font-style", "font-weight", "size", "rotation", "gap", "initial-gap", "radius"};

    @Test
    public void testMalformed() throws Exception {
        String ysld = "foo:\n  foo: bar\n   foo: bar\n";
        List<MarkedYAMLException> errors = this.validate(ysld);
        Assert.assertEquals((long)1L, (long)errors.size());
        MarkedYAMLException e = errors.get(0);
        Assert.assertEquals((long)2L, (long)e.getProblemMark().getLine());
    }

    @Test
    public void testColor() throws Exception {
        String ysld = "fill-color: 21xyz";
        List<MarkedYAMLException> errors = this.validate(ysld);
        Assert.assertEquals((long)1L, (long)errors.size());
        MarkedYAMLException e = errors.get(0);
        Assert.assertEquals((long)0L, (long)e.getProblemMark().getLine());
        Assert.assertEquals((long)12L, (long)e.getProblemMark().getColumn());
    }

    @Test
    public void testFilter() throws Exception {
        String ysld = "filter: foo";
        List<MarkedYAMLException> errors = this.validate(ysld);
        Assert.assertEquals((long)1L, (long)errors.size());
        MarkedYAMLException e = errors.get(0);
        Assert.assertThat((Object)e.getProblemMark(), this.problemAt(1, 9));
    }

    @Test
    public void testFilterOK() throws Exception {
        String ysld = "filter: scalerank < 4";
        List<MarkedYAMLException> errors = this.validate(ysld);
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    @Test
    public void testFilterOWithBracesK() throws Exception {
        String ysld = "filter: ${scalerank < 4}";
        List<MarkedYAMLException> errors = this.validate(ysld);
        Assert.assertEquals((long)0L, (long)errors.size());
    }

    Matcher<Mark> problemAt(int line, int column) {
        return Matchers.describedAs((String)"Problem at Line %0 Column %1", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"line", (Matcher)Matchers.is((Object)(line - 1))), (Matcher)Matchers.hasProperty((String)"column", (Matcher)Matchers.is((Object)(column - 1)))), (Object[])new Object[]{line, column});
    }

    Matcher<Mark> problemOn(int line) {
        return Matchers.describedAs((String)"Problem somewhere on Line %0", (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasProperty((String)"line", (Matcher)Matchers.is((Object)(line - 1)))}), (Object[])new Object[]{line});
    }

    @Test
    public void testExpression() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- symbolizers:\n  - line:\n");
        for (String key : EXPRESSION_KEYS) {
            builder.append("      ").append(key).append(": ").append("${round([len] 1000)}").append("\n");
            builder.append("      ").append(key).append(": ").append("${round([len] / 1000)}").append("\n");
        }
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)EXPRESSION_KEYS.length));
        int firstErrorLine = 4;
        for (int i = 0; i < EXPRESSION_KEYS.length; ++i) {
            Assert.assertThat((Object)errors.get(i).getProblemMark(), this.problemOn(i * 2 + 4));
        }
    }

    @Test
    public void testWellKnownZoomContext() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n  name: WGS84\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNotWellKnownZoomContext() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n  name: SIGMA:957\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)errors.get(0).getProblemMark(), this.problemOn(2));
    }

    @Test
    public void testExtendedZoomContext() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n  name: SIGMA:957\n");
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock((String)"finder", ZoomContextFinder.class);
        ZoomContext zctxt = (ZoomContext)EasyMock.createMock((String)"zctxt", ZoomContext.class);
        EasyMock.expect((Object)finder.get("SIGMA:957")).andStubReturn((Object)zctxt);
        EasyMock.replay((Object[])new Object[]{finder, zctxt});
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.singletonList(finder));
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)0));
        EasyMock.verify((Object[])new Object[]{finder, zctxt});
    }

    @Test
    public void testZoomContextEPSG4326IsBad() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n  name: EPSG:4326\n");
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock((String)"finder", ZoomContextFinder.class);
        ZoomContext zctxt = (ZoomContext)EasyMock.createMock((String)"zctxt", ZoomContext.class);
        EasyMock.expect((Object)finder.get("EPSG:4326")).andStubReturn((Object)zctxt);
        EasyMock.replay((Object[])new Object[]{finder, zctxt});
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.singletonList(finder));
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)errors.get(0).getProblemMark(), this.problemOn(2));
        EasyMock.verify((Object[])new Object[]{finder, zctxt});
    }

    List<MarkedYAMLException> dump(List<MarkedYAMLException> errors) {
        for (MarkedYAMLException markedYAMLException : errors) {
        }
        return errors;
    }

    @Test
    public void testZoomWithDefaultGridValidateOrder() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- zoom: [0,1]\n- zoom: [1,2]\n- zoom: [-1,2]\n- zoom: [1, 0]\n- zoom: [100, 10]\n- zoom: [-2, -10]\n- zoom: [2, -2]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(5)), Matchers.hasProperty((String)"problemMark", this.problemOn(6)), Matchers.hasProperty((String)"problemMark", this.problemOn(7)), Matchers.hasProperty((String)"problemMark", this.problemOn(8))}));
    }

    @Test
    public void testZoomWithDefaultGridTupleSize() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- zoom: [0,0]\n- zoom: []\n- zoom: [0]\n- zoom: [0,0,0]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(3)), Matchers.hasProperty((String)"problemMark", this.problemOn(4)), Matchers.hasProperty((String)"problemMark", this.problemOn(5))}));
    }

    @Test
    public void testZoomWithDefaultGridValidateRange() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- zoom: [0,max]\n- zoom: [min,0]\n- zoom: [19,max]\n- zoom: [min,19]\n- zoom: [-1, max]\n- zoom: [min, -1]\n- zoom: [min, foo]\n- zoom: [foo, max]\n- zoom: [0.5, max]\n- zoom: [min, 0.5]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(8)), Matchers.hasProperty((String)"problemMark", this.problemOn(9)), Matchers.hasProperty((String)"problemMark", this.problemOn(10)), Matchers.hasProperty((String)"problemMark", this.problemOn(11))}));
    }

    @Test
    public void testScaleTupleSize() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- scale: [0.0,0.0]\n- scale: []\n- scale: [0.0]\n- scale: [0.0,0.0,0.0]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(3)), Matchers.hasProperty((String)"problemMark", this.problemOn(4)), Matchers.hasProperty((String)"problemMark", this.problemOn(5))}));
    }

    @Test
    public void testScaleValidateRange() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n- scale: [100000,max]\n- scale: [min,100000]\n- scale: [10000000,max]\n- scale: [min,10000000]\n- scale: [-1, max]\n- scale: [min, -1]\n- scale: [min, foo]\n- scale: [foo, max]\n- scale: [100000.1, max]\n- scale: [min, 100000.1]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(6)), Matchers.hasProperty((String)"problemMark", this.problemOn(7)), Matchers.hasProperty((String)"problemMark", this.problemOn(8)), Matchers.hasProperty((String)"problemMark", this.problemOn(9))}));
    }

    @Test
    public void testZoomWithExtendedGridValidateRange() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n  name: SIGMA:957\nrules:\n- zoom: [0,max]\n- zoom: [min,0]\n- zoom: [2,max]\n- zoom: [min,2]\n- zoom: [5,max]\n- zoom: [min,5]\n- zoom: [6, max]\n- zoom: [min, 6]\n- zoom: [-1, max]\n- zoom: [min, -1]\n- zoom: [min, foo]\n- zoom: [foo, max]\n- zoom: [0.5, max]\n- zoom: [min, 0.5]\n");
        ZoomContextFinder finder = (ZoomContextFinder)EasyMock.createMock((String)"finder", ZoomContextFinder.class);
        ZoomContext zctxt = (ZoomContext)EasyMock.createMock((String)"zctxt", ZoomContext.class);
        EasyMock.expect((Object)finder.get("SIGMA:957")).andStubReturn((Object)zctxt);
        EasyMock.expect((Object)zctxt.isInRange(0)).andStubReturn((Object)true);
        EasyMock.expect((Object)zctxt.isInRange(2)).andStubReturn((Object)true);
        EasyMock.expect((Object)zctxt.isInRange(5)).andStubReturn((Object)true);
        EasyMock.expect((Object)zctxt.isInRange(-1)).andStubReturn((Object)false);
        EasyMock.expect((Object)zctxt.isInRange(6)).andStubReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{finder, zctxt});
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.singletonList(finder));
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(10)), Matchers.hasProperty((String)"problemMark", this.problemOn(11)), Matchers.hasProperty((String)"problemMark", this.problemOn(12)), Matchers.hasProperty((String)"problemMark", this.problemOn(13)), Matchers.hasProperty((String)"problemMark", this.problemOn(14)), Matchers.hasProperty((String)"problemMark", this.problemOn(15)), Matchers.hasProperty((String)"problemMark", this.problemOn(16)), Matchers.hasProperty((String)"problemMark", this.problemOn(17))}));
        EasyMock.verify((Object[])new Object[]{finder, zctxt});
    }

    @Test
    public void testAnchorTupleSize() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n");
        builder.append("- point: \n    anchor: [0.75, 0.25]\n");
        builder.append("- point: \n    anchor: []\n");
        builder.append("- point: \n    anchor: [0.0]\n");
        builder.append("- point: \n    anchor: [0.0, 0.0, 0.0]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(5)), Matchers.hasProperty((String)"problemMark", this.problemOn(7)), Matchers.hasProperty((String)"problemMark", this.problemOn(9))}));
    }

    @Test
    public void testAnchorValidateValues() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n");
        builder.append("- point: \n    anchor: [0.75, 0.25]\n");
        builder.append("- point: \n    anchor: [-1000, -0.0001]\n");
        builder.append("- point: \n    anchor: [\"${round([len]/1000)}\", 0.0]\n");
        builder.append("- point: \n    anchor: [0.0, \"${round([len]/1000)}\"]\n");
        builder.append("- point: \n    anchor: [\"${round([len] 1000)}\", 0.0]\n");
        builder.append("- point: \n    anchor: [0.0, \"${round([len] 1000)}\"]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(11)), Matchers.hasProperty((String)"problemMark", this.problemOn(13))}));
    }

    @Test
    public void testDisplacementTupleSize() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n");
        builder.append("- point: \n    displacement: [0, 0]\n");
        builder.append("- point: \n    displacement: []\n");
        builder.append("- point: \n    displacement: [0]\n");
        builder.append("- point: \n    displacement: [0, 0, 0]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(5)), Matchers.hasProperty((String)"problemMark", this.problemOn(7)), Matchers.hasProperty((String)"problemMark", this.problemOn(9))}));
    }

    @Test
    public void testDisplacementValidateValues() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("rules:\n");
        builder.append("- point: \n    displacement: [1, 1]\n");
        builder.append("- point: \n    displacement: [-1, -2]\n");
        builder.append("- point: \n    displacement: [\"${round([len]/1000)}\", 0]\n");
        builder.append("- point: \n    displacement: [0, \"${round([len]/1000)}\"]\n");
        builder.append("- point: \n    displacement: [\"${round([len] 1000)}\", 0]\n");
        builder.append("- point: \n    displacement: [0, \"${round([len] 1000)}\"]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(11)), Matchers.hasProperty((String)"problemMark", this.problemOn(13))}));
    }

    @Test
    public void testColourMapEntries() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("raster: \n  color-map:\n    type: values\n    entries:\n");
        builder.append("    - [\"#ff0000\", 1.0, 0, \"start\"]\n");
        builder.append("    - [red, 1, 0, \"blah\"]\n");
        builder.append("    - [\"rgb(0,0,0)\", null, 0, \"start\"]\n");
        builder.append("    - [\"#ff0000\", '', 0, null]\n");
        builder.append("    - [\"${[something]}\", \"${[something]}\", \"${[something]}\", null]\n");
        builder.append("    - [\"#ff0000\", \"${round([len] 1000)}\", 0, \"start\"]\n");
        builder.append("    - [\"#ff0000\", 1.0, \"${round([len] 1000)}\", \"start\"]\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.hasProperty((String)"problemMark", this.problemOn(10)), Matchers.hasProperty((String)"problemMark", this.problemOn(11))}));
    }

    @Test
    public void testWellKnownZoomContextWithOtherError() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("grid:\n");
        builder.append("  name: WebMercator\n");
        builder.append("filter: foo\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat((Object)errors.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)errors.get(0).getProblemMark(), this.problemOn(3));
    }

    List<MarkedYAMLException> validate(String ysld) throws IOException {
        return this.validate(ysld, Collections.emptyList());
    }

    List<MarkedYAMLException> validate(String ysld, List<ZoomContextFinder> ctxts) throws IOException {
        return Ysld.validate((Object)ysld, ctxts, (UomMapper)new UomMapper());
    }

    @Test
    public void testRenderingTransform() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("transform:").append("\n").append("  name: ras:Contour").append("\n").append("  input: data").append("\n").append("  params:").append("\n").append("    levels:").append("\n").append("    - -10").append("\n").append("    - -5").append("\n").append("    - 0").append("\n").append("    - 5").append("\n").append("    - 10").append("\n").append("    simplify: true").append("\n").append("");
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testNestedRenderingTransform() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("transform:").append("\n").append("  name: ras:Contour").append("\n").append("  params:").append("\n").append("    data:").append("\n").append("      name: vec:BarnesSurface").append("\n").append("      input: data").append("\n").append("      params:").append("\n").append("        valueAttr: natlscale").append("\n").append("        dataLimit: 500").append("\n").append("        scale: 15.0").append("\n").append("        convergence: 0.2").append("\n").append("        passes: 3").append("\n").append("        minObservations: 2").append("\n").append("        maxObservationDistance: 15").append("\n").append("        pixelsPerCell: 8").append("\n").append("        queryBuffer: 40").append("\n").append("    levels:").append("\n").append("    - -10").append("\n").append("    - -5").append("\n").append("    - 0").append("\n").append("    - 5").append("\n").append("    - 10").append("\n").append("    simplify: true").append("\n").append("");
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testErrorAfterNestedRenderingTransform() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("transform:").append("\n").append("  name: ras:Contour").append("\n").append("  params:").append("\n").append("    data:").append("\n").append("      name: vec:BarnesSurface").append("\n").append("      input: data").append("\n").append("      params:").append("\n").append("        valueAttr: natlscale").append("\n").append("        dataLimit: 500").append("\n").append("        scale: 15.0").append("\n").append("        convergence: 0.2").append("\n").append("        passes: 3").append("\n").append("        minObservations: 2").append("\n").append("        maxObservationDistance: 15").append("\n").append("        pixelsPerCell: 8").append("\n").append("        queryBuffer: 40").append("\n").append("    levels:").append("\n").append("    - -10").append("\n").append("    - -5").append("\n").append("    - 0").append("\n").append("    - 5").append("\n").append("    - 10").append("\n").append("    simplify: true").append("\n").append("rules:").append("\n").append("- point:").append("\n").append("    displacement: []").append("\n").append("");
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"problemMark", this.problemOn(26))));
    }

    @Test
    public void testTupleInVariable() throws Exception {
        String yaml = "define: &s [400000,max]\n\nfeature-styles:\n- rules:\n  - scale: *s\n    filter: ${x = true}\n";
        List<MarkedYAMLException> errors = this.validate(yaml, Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testVariableInTuple() throws Exception {
        String yaml = "define: &s 400000\n\nfeature-styles:\n- rules:\n  - scale: [*s, max]\n    filter: ${x = true}\n";
        List<MarkedYAMLException> errors = this.validate(yaml, Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testVariableInPermissive() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("define: &p -5\n").append("transform:").append("\n").append("  name: ras:Contour").append("\n").append("  input: data").append("\n").append("  params:").append("\n").append("    levels:").append("\n").append("    - -10").append("\n").append("    - *p").append("\n").append("    - 0").append("\n").append("    - 5").append("\n").append("    - 10").append("\n").append("    simplify: true").append("\n").append("");
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testPermissiveInVariable() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("define: &p\n").append("    levels:").append("\n").append("    - -10").append("\n").append("    - -5").append("\n").append("    - 0").append("\n").append("    - 5").append("\n").append("    - 10").append("\n").append("    simplify: true").append("\n").append("transform:").append("\n").append("  name: ras:Contour").append("\n").append("  input: data").append("\n").append("  params: *p").append("\n").append("");
        List<MarkedYAMLException> errors = this.validate(builder.toString(), Collections.EMPTY_LIST);
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testColourMapEntryAsVariable() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("define: &e [red, 1, 0, \"blah\"]\n");
        builder.append("raster: \n  color-map:\n    type: values\n    entries:\n");
        builder.append("    - [\"#ff0000\", 1.0, 0, \"start\"]\n");
        builder.append("    - *e\n");
        builder.append("    - [\"rgb(0,0,0)\", null, 0, \"start\"]\n");
        builder.append("  filter: ${foo = true}\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testColourMapAsVariable() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("define: &c \n");
        builder.append("  - [\"#ff0000\", 1.0, 0, \"start\"]\n");
        builder.append("  - [red, 1, 0, \"blah\"]\n");
        builder.append("  - [\"rgb(0,0,0)\", null, 0, \"start\"]\n");
        builder.append("raster: \n  color-map:\n    type: values\n    entries: *c\n");
        builder.append("  filter: ${foo = true}\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testColourAsVariable() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("define: &color '#ff9900'\n");
        builder.append("symbolizers:\n");
        builder.append("- polygon:\n");
        builder.append("    fill-color: *color\n");
        builder.append("    stroke-color: '#000000'\n");
        List<MarkedYAMLException> errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
        builder = new StringBuilder();
        builder.append("define: &color '#ff9900'\n");
        builder.append("symbolizers:\n");
        builder.append("- polygon:\n");
        builder.append("    fill-color: *color\n");
        builder.append("    stroke-color: '#000000'\n");
        errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
        builder = new StringBuilder();
        builder.append("define: &color '#000000'\n");
        builder.append("symbolizers:\n");
        builder.append("- polygon:\n");
        builder.append("    fill-color: '#ff9900'\n");
        builder.append("    stroke-color: *color\n");
        errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
        builder = new StringBuilder();
        builder.append("define: &color '#000000'\n");
        builder.append("symbolizers:\n");
        builder.append("- polygon:\n");
        builder.append("    stroke-color: *color\n");
        builder.append("    fill-color: '#ff9900'\n");
        errors = this.validate(builder.toString());
        Assert.assertThat(errors, (Matcher)Matchers.empty());
    }
}

