/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import org.geotools.styling.Halo;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.ysld.encode.AnchorPointEncoder;
import org.geotools.ysld.encode.DisplacementEncoder;
import org.geotools.ysld.encode.FillEncoder;
import org.geotools.ysld.encode.FontEncoder;
import org.geotools.ysld.encode.GraphicEncoder;
import org.geotools.ysld.encode.SymbolizerEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class TextSymbolizerEncoder
extends SymbolizerEncoder<TextSymbolizer> {
    TextSymbolizerEncoder(TextSymbolizer text) {
        super(text);
    }

    @Override
    protected void encode(TextSymbolizer text) {
        this.put("label", text.getLabel());
        this.put("priority", text.getPriority());
        this.inline(new FillEncoder(text.getFill()));
        this.inline(new HaloEncoder(text.getHalo()));
        this.inline(new FontEncoder(text.getFont()));
        this.inline(new PlacementEncoder(text.getLabelPlacement()));
        if (text instanceof TextSymbolizer2) {
            this.inline(new GraphicEncoder(((TextSymbolizer2)text).getGraphic(), false));
        }
        super.encode(text);
    }

    static class HaloEncoder
    extends YsldEncodeHandler<Halo> {
        public HaloEncoder(Halo halo) {
            super(halo);
        }

        @Override
        protected void encode(Halo h) {
            this.push("halo");
            this.inline(new FillEncoder(h.getFill()));
            this.put("radius", h.getRadius());
        }
    }

    static class PlacementEncoder
    extends YsldEncodeHandler<LabelPlacement> {
        PlacementEncoder(LabelPlacement placement) {
            super(placement);
        }

        @Override
        protected void encode(LabelPlacement placement) {
            if (placement instanceof LinePlacement) {
                this.put("placement", "line");
                this.put("offset", ((LinePlacement)placement).getPerpendicularOffset());
            } else if (placement instanceof PointPlacement) {
                PointPlacement pp = (PointPlacement)placement;
                this.put("placement", "point");
                this.inline(new AnchorPointEncoder(pp.getAnchorPoint()));
                this.inline(new DisplacementEncoder(pp.getDisplacement()));
                this.put("rotation", this.nullIf(pp.getRotation(), 0.0));
            }
        }
    }
}

