/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.awt.Color;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.UomMapper;
import org.geotools.ysld.parse.Util;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class YsldRepresenter
extends Representer {
    UomMapper uomMapper;

    public YsldRepresenter(UomMapper uomMapper) {
        this.multiRepresenters.put(Color.class, new RepresentColor());
        this.multiRepresenters.put(Unit.class, new RepresentUom());
        this.multiRepresenters.put(Tuple.class, new RepresentTuple());
        this.uomMapper = uomMapper;
    }

    class RepresentTuple
    implements Represent {
        RepresentTuple() {
        }

        public Node representData(Object data) {
            Tuple t = (Tuple)data;
            return YsldRepresenter.this.representSequence(Tag.SEQ, t.toList(), DumperOptions.FlowStyle.FLOW);
        }
    }

    class RepresentUom
    implements Represent {
        RepresentUom() {
        }

        public Node representData(Object data) {
            Unit unit = (Unit)data;
            String value = YsldRepresenter.this.uomMapper.getIdentifier((Unit<Length>)unit);
            return YsldRepresenter.this.representScalar(Tag.STR, value);
        }
    }

    class RepresentColor
    implements Represent {
        RepresentColor() {
        }

        public Node representData(Object data) {
            Color c = (Color)data;
            String value = Util.serializeColor(c);
            return YsldRepresenter.this.representScalar(Tag.STR, value);
        }
    }
}

