/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import javax.annotation.Nullable;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.ysld.Tuple;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlObject;
import org.geotools.ysld.YamlSeq;
import org.geotools.ysld.parse.Factory;
import org.geotools.ysld.parse.GraphicParser;
import org.geotools.ysld.parse.ScaleRange;
import org.geotools.ysld.parse.SymbolizersParser;
import org.geotools.ysld.parse.Util;
import org.geotools.ysld.parse.WellKnownZoomContextFinder;
import org.geotools.ysld.parse.YamlParseContext;
import org.geotools.ysld.parse.YsldParseHandler;
import org.geotools.ysld.parse.ZoomContext;
import org.opengis.style.GraphicLegend;

public class RuleParser
extends YsldParseHandler {
    FeatureTypeStyle featureStyle;

    public RuleParser(FeatureTypeStyle featureStyle, Factory factory) {
        super(factory);
        this.featureStyle = featureStyle;
    }

    @Override
    public void handle(YamlObject<?> obj, YamlParseContext context) {
        YamlSeq seq = obj.seq();
        for (YamlObject<Object> o : seq) {
            YamlMap r = o.map();
            final Rule rule = this.factory.style.createRule();
            this.featureStyle.rules().add(rule);
            rule.setName(r.str("name"));
            if (r.has("title")) {
                rule.getDescription().setTitle(r.str("title"));
            }
            if (r.has("abstract")) {
                rule.getDescription().setAbstract(r.str("abstract"));
            }
            rule.getDescription().setTitle(r.str("title"));
            rule.getDescription().setAbstract(r.str("abstract"));
            context.push(r, "legend", new GraphicParser(this.factory){

                @Override
                protected void graphic(Graphic g) {
                    rule.setLegend((GraphicLegend)g);
                }
            });
            if (r.has("filter")) {
                try {
                    rule.setFilter(ECQL.toFilter((String)Util.removeExpressionBrackets(r.str("filter"))));
                }
                catch (CQLException e) {
                    throw new RuntimeException("Error parsing filter", e);
                }
            }
            rule.setElseFilter(r.boolOr("else", false).booleanValue());
            ScaleRange range = Util.defaultForNull(this.parseScale(r), this.parseZoom(r, context));
            if (range != null) {
                range.applyTo(rule);
            }
            context.push(r, "symbolizers", new SymbolizersParser(rule, this.factory));
        }
    }

    @Nullable
    private ScaleRange parseScale(YamlMap r) {
        if (r.has("scale")) {
            Object value = r.get("scale");
            Tuple t = null;
            try {
                t = Tuple.of(2).parse(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Bad scale value: '%s', must be of form [<min>,<max>]", value), e);
            }
            double min = 0.0;
            double max = Double.POSITIVE_INFINITY;
            if (t.at(0) != null && !t.strAt(0).equalsIgnoreCase("min")) {
                min = Double.parseDouble(t.strAt(0));
            }
            if (t.at(1) != null && !t.strAt(1).equalsIgnoreCase("max")) {
                max = Double.parseDouble(t.strAt(1));
            }
            return new ScaleRange(min, max);
        }
        return null;
    }

    private ScaleRange parseZoom(YamlMap r, YamlParseContext context) {
        if (r.has("zoom")) {
            ZoomContext zCtxt = this.getZoomContext(context);
            Object value = r.get("zoom");
            Tuple t = null;
            try {
                t = Tuple.of(2).parse(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Bad zoom value: '%s', must be of form [<min>,<max>]", value), e);
            }
            Integer min = null;
            Integer max = null;
            if (t.at(0) != null && !t.strAt(0).equalsIgnoreCase("min")) {
                min = Integer.parseInt(t.strAt(0));
            }
            if (t.at(1) != null && !t.strAt(1).equalsIgnoreCase("max")) {
                max = Integer.parseInt(t.strAt(1));
            }
            return zCtxt.getRange(min, max);
        }
        return null;
    }

    protected ZoomContext getZoomContext(YamlParseContext context) {
        return Util.forceDefaultForNull((ZoomContext)context.getDocHint("ZoomContext"), WellKnownZoomContextFinder.getInstance().get("DEFAULT"));
    }
}

