/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.geotools.ysld.parse.ListZoomContext;
import org.geotools.ysld.parse.RatioZoomContext;
import org.geotools.ysld.parse.ZoomContext;
import org.geotools.ysld.parse.ZoomContextFinder;

public class WellKnownZoomContextFinder
implements ZoomContextFinder {
    private static WellKnownZoomContextFinder INSTANCE = new WellKnownZoomContextFinder();
    final Set<String> canonicalNames;
    final Map<String, ZoomContext> contexts = new HashMap<String, ZoomContext>();

    public static WellKnownZoomContextFinder getInstance() {
        return INSTANCE;
    }

    private WellKnownZoomContextFinder() {
        this.canonicalNames = new TreeSet<String>();
        RatioZoomContext googleMercatorExtended = new RatioZoomContext(5.590822639508929E8, 2.0);
        this.contexts.put("WebMercator".toUpperCase(), googleMercatorExtended);
        this.contexts.put("SphericalMercator".toUpperCase(), googleMercatorExtended);
        this.contexts.put("GoogleMercator".toUpperCase(), googleMercatorExtended);
        this.contexts.put("EPSG:3587".toUpperCase(), googleMercatorExtended);
        this.contexts.put("EPSG:900913".toUpperCase(), googleMercatorExtended);
        this.contexts.put("EPSG:3857".toUpperCase(), googleMercatorExtended);
        this.contexts.put("EPSG:3785".toUpperCase(), googleMercatorExtended);
        this.contexts.put("OSGEO:41001".toUpperCase(), googleMercatorExtended);
        this.contexts.put("DEFAULT".toUpperCase(), googleMercatorExtended);
        this.canonicalNames.add("EPSG:3857");
        RatioZoomContext plateCarree = new RatioZoomContext(5.590822639508929E8, 2.0);
        this.contexts.put("PlateCarree".toUpperCase(), plateCarree);
        this.contexts.put("PlateCarr\u00e9e".toUpperCase(), plateCarree);
        this.contexts.put("WGS84".toUpperCase(), plateCarree);
        this.contexts.put("CRS84".toUpperCase(), plateCarree);
        this.contexts.put("GoogleCRS84Quad".toUpperCase(), plateCarree);
        this.canonicalNames.add("WGS84");
        ListZoomContext niceScales = new ListZoomContext(Arrays.asList(5.0E9, 2.0E9, 1.0E9, 5.0E8, 2.0E8, 1.0E8, 5.0E7, 2.0E7, 1.0E7, 5000000.0, 2000000.0, 1000000.0, 500000.0, 200000.0, 100000.0, 50000.0, 20000.0, 10000.0, 5000.0, 2000.0, 1000.0, 500.0, 200.0, 100.0, 50.0, 20.0, 10.0, 5.0, 2.0, 1.0), -3);
        this.contexts.put("NiceScales".toUpperCase(), niceScales);
        this.canonicalNames.add("NiceScales");
    }

    @Override
    @Nullable
    public ZoomContext get(String name) {
        return this.contexts.get(name.toUpperCase());
    }

    @Override
    public Set<String> getNames() {
        return this.contexts.keySet();
    }

    @Override
    public Set<String> getCanonicalNames() {
        return Collections.unmodifiableSet(this.canonicalNames);
    }
}

