/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import org.geotools.ysld.validate.StatefulValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class PermissiveValidator
extends StatefulValidator {
    int depth = 0;
    State state = State.NEW;

    private void start(Event evt, YsldValidateContext context) {
        if (this.state == State.NEW) {
            this.state = State.STARTED;
        }
        ++this.depth;
    }

    private void end(Event evt, YsldValidateContext context) {
        if (this.state == State.STARTED) {
            --this.depth;
            if (this.depth == 0) {
                this.state = State.DONE;
                context.pop();
            }
        } else {
            context.error("Unexpected End of " + (evt instanceof MappingEndEvent ? "Mapping" : "Sequence"), evt.getStartMark());
        }
    }

    @Override
    public void mapping(MappingStartEvent evt, YsldValidateContext context) {
        this.start((Event)evt, context);
    }

    @Override
    public void scalar(ScalarEvent evt, YsldValidateContext context) {
        if (this.state == State.NEW) {
            context.pop();
            this.state = State.DONE;
        }
    }

    @Override
    public void sequence(SequenceStartEvent evt, YsldValidateContext context) {
        this.start((Event)evt, context);
    }

    @Override
    public void endMapping(MappingEndEvent evt, YsldValidateContext context) {
        this.end((Event)evt, context);
    }

    @Override
    public void endSequence(SequenceEndEvent evt, YsldValidateContext context) {
        this.end((Event)evt, context);
    }

    @Override
    void reset() {
        this.state = State.NEW;
        this.depth = 0;
    }

    @Override
    public void alias(AliasEvent evt, YsldValidateContext context) {
        switch (this.state) {
            case NEW: {
                this.state = State.DONE;
                context.pop();
                break;
            }
            case STARTED: {
                break;
            }
            default: {
                context.error(String.format("Unexpected alias '%s'", evt.getAnchor()), evt.getStartMark());
            }
        }
    }

    static enum State {
        NEW,
        STARTED,
        DONE;

    }
}

