/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.encode;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.api.data.Parameter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.ysld.ProcessUtil;
import org.geotools.ysld.encode.FeatureStyleEncoder;
import org.geotools.ysld.encode.YsldEncodeHandler;

public class TransformEncoder
extends YsldEncodeHandler<Expression> {
    boolean chained;

    public TransformEncoder(Expression tx) {
        this(tx, false);
    }

    public TransformEncoder(Expression tx, boolean chained) {
        super(tx);
        this.chained = chained;
    }

    @Override
    protected void encode(Expression tx) {
        if (ProcessUtil.loadProcessFunctionFactory() == null) {
            FeatureStyleEncoder.LOG.warning("Skipping transform, unable to load process factory, ensure process modules installed");
            return;
        }
        if (!(tx instanceof Function)) {
            FeatureStyleEncoder.LOG.warning("Skipping transform, expected a function but got: " + tx);
            return;
        }
        Function ftx = (Function)tx;
        Map<String, Parameter<?>> paramInfo = ProcessUtil.loadProcessInfo(ProcessUtil.processName(ftx.getName()));
        if (paramInfo == null) {
            FeatureStyleEncoder.LOG.warning("Skipping transform, unable to locate process named: " + ftx.getName());
            return;
        }
        boolean wmsParams = ProcessUtil.hasWMSParams(paramInfo);
        this.put("name", ftx.getName());
        LinkedHashMap<String, Object> simpleParams = new LinkedHashMap<String, Object>();
        String input = null;
        for (Expression expr : ftx.getParameters()) {
            ArrayList<Object> paramValue;
            if (!(expr instanceof Function)) {
                FeatureStyleEncoder.LOG.warning("Skipping parameter, expected a function but got: " + expr);
                continue;
            }
            Function fexpr = (Function)expr;
            if (fexpr.getParameters().isEmpty()) {
                FeatureStyleEncoder.LOG.warning("Skipping parameter, must have at least one value");
                continue;
            }
            String paramName = (String)((Expression)fexpr.getParameters().get(0)).evaluate(null, String.class);
            if (fexpr.getParameters().size() == 1) {
                input = paramName;
                continue;
            }
            if (fexpr.getParameters().size() == 2) {
                paramValue = this.intermediateExpression((Expression)fexpr.getParameters().get(1));
            } else {
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 1; i < fexpr.getParameters().size(); ++i) {
                    l.add(this.intermediateExpression((Expression)fexpr.getParameters().get(i)));
                }
                paramValue = l;
            }
            if (wmsParams && this.isDefaultWMSParam(paramName, paramValue)) continue;
            simpleParams.put(paramName, paramValue);
        }
        if (input != null && (this.chained || !input.equals("data"))) {
            this.put("input", input);
        }
        this.push("params").inline(simpleParams);
    }

    private boolean isDefaultWMSParam(String paramName, Object paramValue) {
        if (paramName.equals("outputBBOX") && paramValue.equals("${env('wms_bbox')}")) {
            return true;
        }
        if (paramName.equals("outputWidth") && paramValue.equals("${env('wms_width')}")) {
            return true;
        }
        return paramName.equals("outputHeight") && paramValue.equals("${env('wms_height')}");
    }

    Object intermediateExpression(Expression e) {
        if (ProcessUtil.isProcess(e)) {
            this.chained = true;
            TransformEncoder enc = new TransformEncoder(e, true);
            enc.reset();
            enc.encode(e);
            return enc.root();
        }
        return this.toObjOrNull(e);
    }
}

