/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.ysld.validate.ScalarValidator;
import org.geotools.ysld.validate.TupleValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.yaml.snakeyaml.events.ScalarEvent;

public abstract class RangeValidator<T extends Comparable<T>>
extends TupleValidator {
    T min = null;

    public RangeValidator() {
        super(Collections.emptyList());
    }

    @Override
    protected List<ScalarValidator> getSubValidators() {
        return Arrays.asList(new ValueValidator(true), new ValueValidator(false));
    }

    abstract T parse(String var1) throws IllegalArgumentException;

    protected void validateParsed(T parsed, ScalarEvent evt, YsldValidateContext context) {
    }

    @Override
    void reset() {
        super.reset();
        this.min = null;
    }

    class ValueValidator
    extends ScalarValidator {
        ValueValidator previous;
        boolean isMin;

        public ValueValidator(boolean isMin) {
            this.isMin = isMin;
        }

        @Override
        protected String validate(String value, ScalarEvent evt, YsldValidateContext context) {
            try {
                if (value != null && !value.isEmpty() && !(this.isMin ? "min" : "max").equalsIgnoreCase(value)) {
                    Object parsed = RangeValidator.this.parse(value);
                    RangeValidator.this.validateParsed(parsed, evt, context);
                    if (this.isMin) {
                        RangeValidator.this.min = parsed;
                    } else if (RangeValidator.this.min != null && parsed != null && RangeValidator.this.min.compareTo(parsed) > 0) {
                        return "Minimum is greater than maximum";
                    }
                }
                return null;
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
        }
    }
}

