/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.Rule;
import org.geotools.styling.zoom.ScaleRange;
import org.geotools.ysld.YamlMap;
import org.geotools.ysld.YamlSeq;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;

public enum TestUtils {


    public static Matcher<Rule> appliesToScale(double scale) {
        return Matchers.describedAs((String)"rule applies to scale denom %0", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"maxScaleDenominator", (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(scale))), (Matcher)Matchers.hasProperty((String)"minScaleDenominator", (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(scale)))), (Object[])new Object[]{scale});
    }

    public static Matcher<ScaleRange> rangeContains(double scale) {
        return Matchers.describedAs((String)"scale range that contains 1:%0", (Matcher)Matchers.allOf((Matcher)Matchers.hasProperty((String)"maxDenom", (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(scale))), (Matcher)Matchers.hasProperty((String)"minDenom", (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(scale)))), (Object[])new Object[]{scale});
    }

    public static Matcher<Expression> literal(Matcher m) {
        return Matchers.allOf((Matcher)Matchers.instanceOf(Literal.class), (Matcher)Matchers.hasProperty((String)"value", (Matcher)m));
    }

    public static Matcher<Expression> literal(Object o) {
        return TestUtils.literal(TestUtils.lexEqualTo(o));
    }

    public static Matcher<Expression> nilExpression() {
        return Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.instanceOf(NilExpression.class));
    }

    public static Matcher<Expression> attribute(String name) {
        return Matchers.allOf((Matcher)Matchers.instanceOf(PropertyName.class), (Matcher)Matchers.hasProperty((String)"propertyName", (Matcher)Matchers.equalTo((Object)name)));
    }

    @SafeVarargs
    public static Matcher<Expression> function(String name, Matcher<Expression> ... parameters) {
        return TestUtils.function(name, (Matcher<? extends Iterable<Expression>>)Matchers.hasItems(parameters));
    }

    public static Matcher<Expression> function(String name, Matcher<? extends Iterable<Expression>> parameters) {
        return Matchers.allOf((Matcher)Matchers.instanceOf(Function.class), (Matcher)Matchers.hasProperty((String)"functionName", (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.equalTo((Object)name))), (Matcher)Matchers.hasProperty((String)"parameters", parameters));
    }

    public static Matcher<? extends Object> lexEqualTo(final Object value) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object arg0) {
                if (arg0 == null) {
                    arg0 = "";
                }
                return arg0.toString().equals(value.toString());
            }

            public void describeTo(Description arg0) {
                arg0.appendText("lexicaly equal to ").appendValue((Object)value.toString());
            }
        };
    }

    public static Matcher<? extends Object> numEqualTo(final double value, final double epsilon) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object obj) {
                double num = obj instanceof Number ? ((Number)obj).doubleValue() : Double.parseDouble(obj.toString());
                return Math.abs(num - value) < epsilon;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("can be parsed as ").appendValue((Object)value);
                arg0.appendText(" to within ").appendValue((Object)epsilon);
            }
        };
    }

    public static Matcher<? extends Object> numEqualTo(final long value) {
        return new BaseMatcher<Object>(){

            public boolean matches(Object obj) {
                double num = obj instanceof Number ? (double)((Number)obj).longValue() : (double)Long.parseLong(obj.toString());
                return num == (double)value;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("can be parsed as ").appendValue((Object)value);
            }
        };
    }

    public static Matcher<String> asHexInt(final Matcher<Integer> m) {
        return new BaseMatcher<String>(){

            public boolean matches(Object arg0) {
                return m.matches((Object)Integer.parseInt((String)arg0, 16));
            }

            public void describeTo(Description arg0) {
                arg0.appendText("Hexadecimal string ").appendDescriptionOf((SelfDescribing)m);
            }
        };
    }

    public static Matcher<String> asColor(final Matcher<Color> m) {
        return new BaseMatcher<String>(){

            public boolean matches(Object arg0) {
                Color c;
                try {
                    c = Color.decode((String)arg0);
                }
                catch (NumberFormatException ex) {
                    c = new Color(Integer.parseInt((String)arg0, 16));
                }
                return m.matches((Object)c);
            }

            public void describeTo(Description arg0) {
                arg0.appendText("represents colour ").appendDescriptionOf((SelfDescribing)m);
            }
        };
    }

    public static Matcher<Object> isColor(Color c) {
        String hex = String.format("#%06x", c.getRGB() & 0xFFFFFF);
        return Matchers.describedAs((String)"is the colour %0 %1", (Matcher)Matchers.anyOf((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(String.class), TestUtils.asColor((Matcher<Color>)Matchers.equalTo((Object)c))), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(Color.class), (Matcher)Matchers.equalTo((Object)c)), (Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(Integer.class), (Matcher)Matchers.equalTo((Object)(c.getRGB() & 0xFFFFFF)))), (Object[])new Object[]{hex, c});
    }

    public static Matcher<Object> isColor(String s) {
        Color c = new Color(Integer.parseInt(s, 16));
        return TestUtils.isColor(c);
    }

    public static Matcher<Object> yHasItem(final int i, final Matcher<? extends Object> m) {
        return new BaseMatcher(){

            public boolean matches(Object obj) {
                if (!(obj instanceof YamlSeq)) {
                    return false;
                }
                YamlSeq seq = (YamlSeq)obj;
                Object value = null;
                try {
                    value = seq.map(i);
                }
                catch (IllegalArgumentException ex1) {
                    try {
                        value = seq.seq(i);
                    }
                    catch (IllegalArgumentException ex2) {
                        value = seq.get(i);
                    }
                }
                return m.matches(value);
            }

            public void describeTo(Description desc) {
                desc.appendText("YamlSeq with item ").appendValue((Object)i).appendText(" that ").appendDescriptionOf((SelfDescribing)m);
            }
        };
    }

    public static Matcher<Object> yHasEntry(final String key, final Matcher<? extends Object> m) {
        return new BaseMatcher(){

            public boolean matches(Object obj) {
                if (!(obj instanceof YamlMap)) {
                    return false;
                }
                YamlMap map = (YamlMap)obj;
                if (!map.has(key)) {
                    return false;
                }
                Object value = null;
                try {
                    value = map.map(key);
                }
                catch (IllegalArgumentException ex1) {
                    try {
                        value = map.seq(key);
                    }
                    catch (IllegalArgumentException ex2) {
                        value = map.get(key);
                    }
                }
                return m.matches(value);
            }

            public void describeTo(Description desc) {
                desc.appendText("YamlMap with entry ").appendValue((Object)key).appendText(" and value ").appendDescriptionOf((SelfDescribing)m);
            }
        };
    }

    public static Matcher<Object> yHasEntry(String key) {
        return TestUtils.yHasEntry(key, (Matcher<? extends Object>)Matchers.any(Object.class));
    }

    @SafeVarargs
    public static Matcher<? extends Object> yContains(final Matcher<? extends Object> ... matchers) {
        return new BaseMatcher(){

            public boolean matches(Object obj) {
                if (!(obj instanceof YamlSeq)) {
                    return false;
                }
                YamlSeq seq = (YamlSeq)obj;
                if (((List)seq.raw()).size() != matchers.length) {
                    return false;
                }
                for (int i = 0; i < matchers.length; ++i) {
                    if (matchers[i].matches(seq.get(i))) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description desc) {
                desc.appendList("Yaml Sequence with values [", ", ", "]", Arrays.asList(matchers));
            }
        };
    }

    @SafeVarargs
    public static Matcher<? extends Object> yTuple(Matcher<? extends Object> ... matchers) {
        return TestUtils.yContains(matchers);
    }

    public static Matcher<? extends Object> yTuple(int n) {
        Object[] matchers = new Matcher[n];
        Arrays.fill(matchers, Matchers.anything());
        return Matchers.describedAs((String)"A YSLD Tuple with %0 values", TestUtils.yTuple(matchers), (Object[])new Object[]{n});
    }

    public static Matcher<? extends Object> fakeString(final Matcher<? extends Object> m) {
        return new BaseMatcher(){

            public boolean matches(Object obj) {
                if (obj instanceof String) {
                    String str = (String)obj;
                    if (str.startsWith("'") && str.endsWith("'")) {
                        str = str.substring(1, str.length() - 1);
                    } else if (str.startsWith("\"") && str.endsWith("\"")) {
                        str = str.substring(1, str.length() - 1);
                    }
                    return m.matches((Object)str);
                }
                return false;
            }

            public void describeTo(Description desc) {
                desc.appendText("a fake YAML string ").appendDescriptionOf((SelfDescribing)m);
            }
        };
    }

    public static Matcher<? extends Object> fakeString(String s) {
        return TestUtils.fakeString((Matcher<? extends Object>)Matchers.equalTo((Object)s));
    }
}

