/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.parse;

import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.styling.SLD;
import org.geotools.ysld.Ysld;
import org.junit.Assert;
import org.junit.Test;

public class YsldParsePartialsTest {
    @Test
    public void testParseRules() throws Exception {
        String ysld = "rules:\n- symbolizers:\n  - point:\n      symbols:\n      - mark:\n         shape: triangle";
        this.assertSLD(Ysld.parse((Object)ysld));
    }

    @Test
    public void testParseSymbolizers() throws Exception {
        String ysld = "symbolizers:\n- point:\n    symbols:\n    - mark:\n       shape: triangle";
        this.assertSLD(Ysld.parse((Object)ysld));
    }

    @Test
    public void testParseSymbolizer() throws Exception {
        String ysld = "point:\n  symbols:\n  - mark:\n     shape: triangle";
        this.assertSLD(Ysld.parse((Object)ysld));
    }

    void assertSLD(StyledLayerDescriptor sld) {
        Assert.assertNotNull((Object)sld);
        PointSymbolizer point = SLD.pointSymbolizer((Style)SLD.defaultStyle((StyledLayerDescriptor)sld));
        Assert.assertNotNull((Object)point);
        Assert.assertEquals((Object)"triangle", (Object)SLD.mark((PointSymbolizer)point).getWellKnownName().evaluate(null));
    }
}

