/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ysld.validate;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import org.geotools.styling.zoom.ZoomContextFinder;
import org.geotools.ysld.YamlUtil;
import org.geotools.ysld.validate.RootValidator;
import org.geotools.ysld.validate.YsldValidateContext;
import org.geotools.ysld.validate.YsldValidateHandler;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class YsldValidator {
    List<ZoomContextFinder> zCtxtFinders = Collections.emptyList();

    public List<MarkedYAMLException> validate(Reader input) throws IOException {
        YsldValidateContext context = new YsldValidateContext();
        context.zCtxtFinders = this.zCtxtFinders;
        context.push(new RootValidator());
        try {
            for (Event evt : YamlUtil.getSafeYaml().parse(input)) {
                YsldValidateHandler h = context.peek();
                if (evt instanceof MappingStartEvent) {
                    h.mapping((MappingStartEvent)evt, context);
                    continue;
                }
                if (evt instanceof MappingEndEvent) {
                    h.endMapping((MappingEndEvent)evt, context);
                    continue;
                }
                if (evt instanceof SequenceStartEvent) {
                    h.sequence((SequenceStartEvent)evt, context);
                    continue;
                }
                if (evt instanceof SequenceEndEvent) {
                    h.endSequence((SequenceEndEvent)evt, context);
                    continue;
                }
                if (evt instanceof ScalarEvent) {
                    h.scalar((ScalarEvent)evt, context);
                    continue;
                }
                if (!(evt instanceof AliasEvent)) continue;
                h.alias((AliasEvent)evt, context);
            }
        }
        catch (MarkedYAMLException e) {
            context.error(e);
        }
        catch (EmptyStackException e) {
            throw new RuntimeException("Error parsing CQL expression", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return context.errors();
    }

    public void setZCtxtFinders(List<ZoomContextFinder> zCtxtFinders) {
        if (zCtxtFinders == null) {
            throw new NullPointerException("zCtxtFinders can not be null");
        }
        this.zCtxtFinders = zCtxtFinders;
    }
}

